/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.editparts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.fbtypeeditor.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteWithCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FunctionFBType;
import org.eclipse.fordiac.ide.model.libraryElement.With;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editpolicies.ConnectionEditPolicy;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.gef.requests.GroupRequest;

public class WithEditPart
extends AbstractConnectionEditPart {
    private static final int WITH_BOX_SIZE = 4;
    private static final float WITH_SCALE = 1.0f;
    private static final int SCALED_WITH_DISTANCE = 10;

    public With getCastedModel() {
        return (With)this.getModel();
    }

    protected boolean isInput() {
        Event event;
        With with = this.getCastedModel();
        if (with != null && (event = (Event)with.eContainer()) != null) {
            return event.isIsInput();
        }
        return false;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointEditPolicy());
        if (this.isInterfaceEditable()) {
            this.installEditPolicy("ConnectionEditPolicy", (EditPolicy)new ConnectionEditPolicy(){

                protected Command getDeleteCommand(GroupRequest request) {
                    return new DeleteWithCommand(WithEditPart.this.getCastedModel());
                }
            });
        }
    }

    protected IFigure createFigure() {
        PolylineConnection connection = (PolylineConnection)super.createFigure();
        this.updateConnection(connection);
        return connection;
    }

    private void updateConnection(PolylineConnection connection) {
        int withPos = InterfaceEditPart.calculateWithPos(this.getCastedModel(), this.isInput());
        PolygonDecoration rectDec = new PolygonDecoration();
        rectDec.setTemplate(this.createPointList(withPos, false));
        rectDec.setScale(1.0, 1.0);
        rectDec.setFill(false);
        connection.setTargetDecoration((RotatableDecoration)rectDec);
        PolygonDecoration rectDec2 = new PolygonDecoration();
        rectDec2.setTemplate(this.createPointList(withPos, true));
        rectDec2.setScale(1.0, 1.0);
        rectDec2.setFill(false);
        connection.setSourceDecoration((RotatableDecoration)rectDec2);
    }

    private PointList createPointList(int withPos, boolean top) {
        PointList rect = new PointList(9);
        rect.addPoint(-4, -4);
        rect.addPoint(-4, 4);
        rect.addPoint(4, 4);
        rect.addPoint(4, -4);
        rect.addPoint(-4, -4);
        rect.addPoint(0, -4);
        if (this.isInput()) {
            if (top) {
                WithEditPart.addRightAlignedLine(withPos, rect);
            } else {
                WithEditPart.addLeftAlignedLine(withPos, rect);
            }
        } else if (top) {
            WithEditPart.addLeftAlignedLine(withPos, rect);
        } else {
            WithEditPart.addRightAlignedLine(withPos, rect);
        }
        rect.addPoint(0, -4);
        return rect;
    }

    private static void addLeftAlignedLine(int withPos, PointList rect) {
        rect.addPoint(0, -10 * withPos);
        rect.addPoint(0, 8);
    }

    private static void addRightAlignedLine(int withPos, PointList rect) {
        rect.addPoint(0, -8);
        rect.addPoint(0, 10 * withPos);
    }

    public void updateWithPos() {
        if (this.getCastedModel().eContainer() != null) {
            this.updateConnection((PolylineConnection)this.getFigure());
            this.refreshSourceAnchor();
            this.refreshTargetAnchor();
        }
    }

    public boolean isInterfaceEditable() {
        return !(EcoreUtil.getRootContainer((EObject)this.getCastedModel()) instanceof FunctionFBType);
    }
}

