/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.value.ValueConverter;

public final class NumericValueConverter
implements ValueConverter<Object> {
    public static final NumericValueConverter INSTANCE = new NumericValueConverter();
    public static final NumericValueConverter INSTANCE_BYTE = new NumericValueConverter("16#%02X");
    public static final NumericValueConverter INSTANCE_WORD = new NumericValueConverter("16#%04X");
    public static final NumericValueConverter INSTANCE_DWORD = new NumericValueConverter("16#%08X");
    public static final NumericValueConverter INSTANCE_LWORD = new NumericValueConverter("16#%016X");
    private static final String TRUE = "TRUE";
    private static final String FALSE = "FALSE";
    private static final Pattern DECIMAL = Pattern.compile("[+-]?\\d[_\\d]*+(?:\\.\\d[_\\d]*+(?:[eE][+-]?\\d[_\\d]*+)?)?");
    private static final Pattern NON_DECIMAL = Pattern.compile("(\\d++)#(\\p{XDigit}[_\\p{XDigit}]*+)");
    private static final Pattern INFINITY = Pattern.compile("[+-]?Inf(?:inity)?", 2);
    private static final Pattern NAN = Pattern.compile("[+-]?NaN", 2);
    private static final Pattern SCANNER_PATTERN = Pattern.compile("\\G(?:TRUE|FALSE|" + String.valueOf(NON_DECIMAL) + "|" + String.valueOf(DECIMAL) + "|" + String.valueOf(INFINITY) + "|" + String.valueOf(NAN) + ")", 2);
    private final String format;

    private NumericValueConverter() {
        this(null);
    }

    private NumericValueConverter(String format) {
        this.format = format;
    }

    @Override
    public Object toValue(String string) throws IllegalArgumentException {
        try {
            if (string.indexOf("__") != -1) {
                throw new IllegalArgumentException(MessageFormat.format(Messages.VALIDATOR_CONSECUTIVE_UNDERSCORES_ERROR_MESSAGE, string));
            }
            if (TRUE.equalsIgnoreCase(string)) {
                return Boolean.TRUE;
            }
            if (FALSE.equalsIgnoreCase(string)) {
                return Boolean.FALSE;
            }
            if (string.equalsIgnoreCase("NaN")) {
                return Double.NaN;
            }
            if (string.equalsIgnoreCase("-NaN")) {
                return Double.NaN;
            }
            Matcher infinityMatcher = INFINITY.matcher(string);
            if (infinityMatcher.matches()) {
                if (string.startsWith("-")) {
                    return Double.NEGATIVE_INFINITY;
                }
                return Double.POSITIVE_INFINITY;
            }
            Matcher nonDecimalMatcher = NON_DECIMAL.matcher(string);
            if (nonDecimalMatcher.matches()) {
                String radixString = nonDecimalMatcher.group(1);
                String numberString = nonDecimalMatcher.group(2).replace("_", "");
                int radix = Integer.parseInt(radixString);
                return new BigInteger(numberString, radix);
            }
            if (string.contains(".")) {
                return new BigDecimal(string.replace("_", ""));
            }
            return new BigInteger(string.replace("_", ""));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.VALIDATOR_INVALID_NUMBER_LITERAL, string), e);
        }
    }

    @Override
    public Object toValue(Scanner scanner) throws IllegalArgumentException {
        return this.toValue(scanner, SCANNER_PATTERN);
    }

    @Override
    public String toString(Object value) {
        if (this.format != null) {
            return String.format(this.format, value);
        }
        return ValueConverter.super.toString(value);
    }

    public String toString() {
        if (this.format != null) {
            return String.format("%s [format=%s]", this.getClass().getSimpleName(), this.format);
        }
        return this.getClass().getSimpleName();
    }
}

