/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.components.AsynchronousListOperation;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;

public class AsynchronousBranchList
extends AsynchronousListOperation<Ref> {
    private final String localBranchName;

    public AsynchronousBranchList(Repository repository, String uriText, String localBranchName) {
        super(repository, uriText);
        this.localBranchName = localBranchName;
    }

    @Override
    protected Collection<Ref> convert(Collection<Ref> refs) {
        ArrayList<Object> filtered = new ArrayList<Ref>();
        String localFullName = this.localBranchName != null ? "refs/heads/" + this.localBranchName : null;
        boolean localBranchFound = false;
        for (Ref ref : refs) {
            String name = ref.getName();
            if (!name.startsWith("refs/heads/")) continue;
            filtered.add(ref);
            if (localFullName == null || !localFullName.equalsIgnoreCase(name)) continue;
            localBranchFound = true;
        }
        Collections.sort(filtered, CommonUtils.REF_ASCENDING_COMPARATOR);
        if (localFullName != null && !localBranchFound) {
            ArrayList<Object> newRefs = new ArrayList<Object>(filtered.size() + 1);
            newRefs.add(new ObjectIdRef.Unpeeled(Ref.Storage.NEW, localFullName, ObjectId.zeroId()));
            newRefs.addAll(filtered);
            filtered = newRefs;
        }
        return filtered;
    }
}

