/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.immutable;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.sorted.MutableSortedBag;
import org.eclipse.collections.api.bimap.MutableBiMap;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleObjectToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.FloatObjectToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.IntObjectToIntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.LongObjectToLongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.factory.primitive.BooleanStacks;
import org.eclipse.collections.api.factory.primitive.ByteStacks;
import org.eclipse.collections.api.factory.primitive.CharStacks;
import org.eclipse.collections.api.factory.primitive.DoubleStacks;
import org.eclipse.collections.api.factory.primitive.FloatStacks;
import org.eclipse.collections.api.factory.primitive.IntStacks;
import org.eclipse.collections.api.factory.primitive.LongStacks;
import org.eclipse.collections.api.factory.primitive.ShortStacks;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.MutableMapIterable;
import org.eclipse.collections.api.map.primitive.ImmutableObjectDoubleMap;
import org.eclipse.collections.api.map.primitive.ImmutableObjectLongMap;
import org.eclipse.collections.api.map.primitive.ObjectDoubleMap;
import org.eclipse.collections.api.map.primitive.ObjectLongMap;
import org.eclipse.collections.api.map.sorted.MutableSortedMap;
import org.eclipse.collections.api.multimap.MutableMultimap;
import org.eclipse.collections.api.multimap.list.ImmutableListMultimap;
import org.eclipse.collections.api.ordered.OrderedIterable;
import org.eclipse.collections.api.partition.stack.PartitionImmutableStack;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.sorted.MutableSortedSet;
import org.eclipse.collections.api.stack.ImmutableStack;
import org.eclipse.collections.api.stack.StackIterable;
import org.eclipse.collections.api.stack.primitive.ImmutableBooleanStack;
import org.eclipse.collections.api.stack.primitive.ImmutableByteStack;
import org.eclipse.collections.api.stack.primitive.ImmutableCharStack;
import org.eclipse.collections.api.stack.primitive.ImmutableDoubleStack;
import org.eclipse.collections.api.stack.primitive.ImmutableFloatStack;
import org.eclipse.collections.api.stack.primitive.ImmutableIntStack;
import org.eclipse.collections.api.stack.primitive.ImmutableLongStack;
import org.eclipse.collections.api.stack.primitive.ImmutableShortStack;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.block.factory.Predicates;
import org.eclipse.collections.impl.block.procedure.checked.CheckedProcedure;
import org.eclipse.collections.impl.list.Interval;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;
import org.eclipse.collections.impl.multimap.list.FastListMultimap;
import org.eclipse.collections.impl.partition.stack.PartitionArrayStack;
import org.eclipse.collections.impl.tuple.Tuples;
import org.eclipse.collections.impl.utility.Iterate;
import org.eclipse.collections.impl.utility.LazyIterate;

@Deprecated
final class ImmutableArrayStack<T>
implements ImmutableStack<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableList<T> delegate;

    private ImmutableArrayStack(T[] newElements) {
        this.delegate = FastList.newListWith(newElements);
    }

    private ImmutableArrayStack(MutableList<T> newElements) {
        this.delegate = newElements;
    }

    public static <T> ImmutableStack<T> newStack() {
        return new ImmutableArrayStack(FastList.newList());
    }

    public static <E> ImmutableArrayStack<E> newStack(Iterable<? extends E> iterable) {
        return new ImmutableArrayStack<Object>(Iterate.toArray(iterable));
    }

    public static <E> ImmutableArrayStack<E> newStackWith(E ... elements) {
        return new ImmutableArrayStack<Object>((Object[])elements.clone());
    }

    public static <T> ImmutableArrayStack<T> newStackFromTopToBottom(Iterable<? extends T> items) {
        return new ImmutableArrayStack<T>(FastList.newList(items).reverseThis());
    }

    public static <T> ImmutableArrayStack<T> newStackFromTopToBottom(T ... items) {
        return new ImmutableArrayStack<T>(FastList.newListWith(items).reverseThis());
    }

    public ImmutableStack<T> push(T item) {
        FastList<T> newDelegate = FastList.newList(this.delegate);
        newDelegate.add(item);
        return new ImmutableArrayStack<T>(newDelegate);
    }

    public ImmutableStack<T> pop() {
        this.checkEmptyStack();
        FastList<T> newDelegate = FastList.newList(this.delegate);
        newDelegate.remove(this.delegate.size() - 1);
        return new ImmutableArrayStack<T>(newDelegate);
    }

    public ImmutableStack<T> pop(int count) {
        this.checkNegativeCount(count);
        if (this.checkZeroCount(count)) {
            return this;
        }
        this.checkEmptyStack();
        this.checkSizeLessThanCount(count);
        MutableList newDelegate = this.delegate.clone();
        while (count > 0) {
            newDelegate.remove(this.delegate.size() - 1);
            --count;
        }
        return new ImmutableArrayStack<T>(newDelegate);
    }

    public Pair<T, ImmutableStack<T>> peekAndPop() {
        return Tuples.pair(this.peek(), this.pop());
    }

    public Pair<ListIterable<T>, ImmutableStack<T>> peekAndPop(int count) {
        return Tuples.pair(this.peek(count), this.pop(count));
    }

    public T peek() {
        this.checkEmptyStack();
        return (T)this.delegate.getLast();
    }

    private void checkEmptyStack() {
        if (this.delegate.isEmpty()) {
            throw new EmptyStackException();
        }
    }

    public ListIterable<T> peek(int count) {
        this.checkNegativeCount(count);
        if (this.checkZeroCount(count)) {
            return FastList.newList();
        }
        this.checkEmptyStack();
        this.checkSizeLessThanCount(count);
        return FastList.newList(this.asLazy().take(count));
    }

    private boolean checkZeroCount(int count) {
        return count == 0;
    }

    private void checkSizeLessThanCount(int count) {
        if (this.delegate.size() < count) {
            throw new IllegalArgumentException("Count must be less than size: Count = " + count + " Size = " + this.delegate.size());
        }
    }

    private void checkSizeLessThanOrEqualToIndex(int index) {
        if (this.delegate.size() <= index) {
            throw new IllegalArgumentException("Count must be less than size: Count = " + index + " Size = " + this.delegate.size());
        }
    }

    private void checkNegativeCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be positive but was " + count);
        }
    }

    public T peekAt(int index) {
        this.checkNegativeCount(index);
        this.checkEmptyStack();
        this.checkSizeLessThanOrEqualToIndex(index);
        return (T)this.delegate.get(this.delegate.size() - 1 - index);
    }

    public T getFirst() {
        return this.peek();
    }

    public T getLast() {
        this.checkEmptyStack();
        return (T)this.delegate.getFirst();
    }

    public T getOnly() {
        return (T)this.delegate.getOnly();
    }

    public boolean contains(Object object) {
        return this.delegate.asReversed().contains(object);
    }

    public boolean containsAllIterable(Iterable<?> source) {
        return this.delegate.asReversed().containsAllIterable(source);
    }

    public boolean containsAll(Collection<?> source) {
        return this.delegate.asReversed().containsAll(source);
    }

    public boolean containsAllArguments(Object ... elements) {
        return this.delegate.asReversed().containsAllArguments(elements);
    }

    public ImmutableStack<T> select(Predicate<? super T> predicate) {
        return ImmutableArrayStack.newStackFromTopToBottom(this.delegate.asReversed().select(predicate).toList());
    }

    public <P> ImmutableStack<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.select(Predicates.bind(predicate, parameter));
    }

    public <R extends Collection<T>> R select(Predicate<? super T> predicate, R target) {
        return (R)this.delegate.asReversed().select(predicate, target);
    }

    public <P, R extends Collection<T>> R selectWith(Predicate2<? super T, ? super P> predicate, P parameter, R targetCollection) {
        return (R)this.delegate.asReversed().selectWith(predicate, parameter, targetCollection);
    }

    public ImmutableStack<T> reject(Predicate<? super T> predicate) {
        return ImmutableArrayStack.newStackFromTopToBottom(this.delegate.asReversed().reject(predicate).toList());
    }

    public <R extends Collection<T>> R reject(Predicate<? super T> predicate, R target) {
        return (R)this.delegate.asReversed().reject(predicate, target);
    }

    public <P> ImmutableStack<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.reject(Predicates.bind(predicate, parameter));
    }

    public <P, R extends Collection<T>> R rejectWith(Predicate2<? super T, ? super P> predicate, P parameter, R targetCollection) {
        return (R)this.delegate.asReversed().rejectWith(predicate, parameter, targetCollection);
    }

    public PartitionImmutableStack<T> partition(Predicate<? super T> predicate) {
        PartitionArrayStack partitionMutableStack = new PartitionArrayStack();
        this.delegate.asReversed().forEach(new PartitionArrayStack.PartitionProcedure<T>(predicate, partitionMutableStack));
        return partitionMutableStack.toImmutable();
    }

    public <P> PartitionImmutableStack<T> partitionWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        PartitionArrayStack partitionMutableStack = new PartitionArrayStack();
        this.delegate.asReversed().forEach(new PartitionArrayStack.PartitionPredicate2Procedure<T, P>(predicate, parameter, partitionMutableStack));
        return partitionMutableStack.toImmutable();
    }

    public <S> ImmutableStack<S> selectInstancesOf(Class<S> clazz) {
        return ImmutableArrayStack.newStackFromTopToBottom(this.delegate.asReversed().selectInstancesOf(clazz).toList());
    }

    public <V> ImmutableStack<V> collect(Function<? super T, ? extends V> function) {
        return ImmutableArrayStack.newStackFromTopToBottom(this.delegate.asReversed().collect(function));
    }

    public ImmutableBooleanStack collectBoolean(BooleanFunction<? super T> booleanFunction) {
        return BooleanStacks.immutable.withAllReversed((BooleanIterable)this.asLazy().collectBoolean(booleanFunction));
    }

    public <R extends MutableBooleanCollection> R collectBoolean(BooleanFunction<? super T> booleanFunction, R target) {
        return (R)this.delegate.asReversed().collectBoolean(booleanFunction, target);
    }

    public <R extends MutableBooleanCollection> R flatCollectBoolean(Function<? super T, ? extends BooleanIterable> function, R target) {
        return (R)this.delegate.asReversed().flatCollectBoolean(function, target);
    }

    public ImmutableByteStack collectByte(ByteFunction<? super T> byteFunction) {
        return ByteStacks.immutable.withAllReversed((ByteIterable)this.asLazy().collectByte(byteFunction));
    }

    public <R extends MutableByteCollection> R collectByte(ByteFunction<? super T> byteFunction, R target) {
        return (R)this.delegate.asReversed().collectByte(byteFunction, target);
    }

    public <R extends MutableByteCollection> R flatCollectByte(Function<? super T, ? extends ByteIterable> function, R target) {
        return (R)this.delegate.asReversed().flatCollectByte(function, target);
    }

    public ImmutableCharStack collectChar(CharFunction<? super T> charFunction) {
        return CharStacks.immutable.withAllReversed((CharIterable)this.asLazy().collectChar(charFunction));
    }

    public <R extends MutableCharCollection> R collectChar(CharFunction<? super T> charFunction, R target) {
        return (R)this.delegate.asReversed().collectChar(charFunction, target);
    }

    public <R extends MutableCharCollection> R flatCollectChar(Function<? super T, ? extends CharIterable> function, R target) {
        return (R)this.delegate.asReversed().flatCollectChar(function, target);
    }

    public ImmutableDoubleStack collectDouble(DoubleFunction<? super T> doubleFunction) {
        return DoubleStacks.immutable.withAllReversed((DoubleIterable)this.asLazy().collectDouble(doubleFunction));
    }

    public <R extends MutableDoubleCollection> R collectDouble(DoubleFunction<? super T> doubleFunction, R target) {
        return (R)this.delegate.asReversed().collectDouble(doubleFunction, target);
    }

    public <R extends MutableDoubleCollection> R flatCollectDouble(Function<? super T, ? extends DoubleIterable> function, R target) {
        return (R)this.delegate.asReversed().flatCollectDouble(function, target);
    }

    public ImmutableFloatStack collectFloat(FloatFunction<? super T> floatFunction) {
        return FloatStacks.immutable.withAllReversed((FloatIterable)this.asLazy().collectFloat(floatFunction));
    }

    public <R extends MutableFloatCollection> R collectFloat(FloatFunction<? super T> floatFunction, R target) {
        return (R)this.delegate.asReversed().collectFloat(floatFunction, target);
    }

    public <R extends MutableFloatCollection> R flatCollectFloat(Function<? super T, ? extends FloatIterable> function, R target) {
        return (R)this.delegate.asReversed().flatCollectFloat(function, target);
    }

    public ImmutableIntStack collectInt(IntFunction<? super T> intFunction) {
        return IntStacks.immutable.withAllReversed((IntIterable)this.asLazy().collectInt(intFunction));
    }

    public <R extends MutableIntCollection> R collectInt(IntFunction<? super T> intFunction, R target) {
        return (R)this.delegate.asReversed().collectInt(intFunction, target);
    }

    public <R extends MutableIntCollection> R flatCollectInt(Function<? super T, ? extends IntIterable> function, R target) {
        return (R)this.delegate.asReversed().flatCollectInt(function, target);
    }

    public ImmutableLongStack collectLong(LongFunction<? super T> longFunction) {
        return LongStacks.immutable.withAllReversed((LongIterable)this.asLazy().collectLong(longFunction));
    }

    public <R extends MutableLongCollection> R collectLong(LongFunction<? super T> longFunction, R target) {
        return (R)this.delegate.asReversed().collectLong(longFunction, target);
    }

    public <R extends MutableLongCollection> R flatCollectLong(Function<? super T, ? extends LongIterable> function, R target) {
        return (R)this.delegate.asReversed().flatCollectLong(function, target);
    }

    public ImmutableShortStack collectShort(ShortFunction<? super T> shortFunction) {
        return ShortStacks.immutable.withAllReversed((ShortIterable)this.asLazy().collectShort(shortFunction));
    }

    public <R extends MutableShortCollection> R collectShort(ShortFunction<? super T> shortFunction, R target) {
        return (R)this.delegate.asReversed().collectShort(shortFunction, target);
    }

    public <R extends MutableShortCollection> R flatCollectShort(Function<? super T, ? extends ShortIterable> function, R target) {
        return (R)this.delegate.asReversed().flatCollectShort(function, target);
    }

    public <V, R extends Collection<V>> R collect(Function<? super T, ? extends V> function, R target) {
        return (R)this.delegate.asReversed().collect(function, target);
    }

    public <P, V> ImmutableStack<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return ImmutableArrayStack.newStackFromTopToBottom(this.delegate.asReversed().collectWith(function, parameter).toList());
    }

    public <P, V, R extends Collection<V>> R collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter, R targetCollection) {
        return (R)this.delegate.asReversed().collectWith(function, parameter, targetCollection);
    }

    public <V> ImmutableStack<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        return ImmutableArrayStack.newStackFromTopToBottom(this.delegate.asReversed().collectIf(predicate, function).toList());
    }

    public <V, R extends Collection<V>> R collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function, R target) {
        return (R)this.delegate.asReversed().collectIf(predicate, function, target);
    }

    public <V> ImmutableStack<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        return ImmutableArrayStack.newStackFromTopToBottom(this.delegate.asReversed().flatCollect(function).toList());
    }

    public <V, R extends Collection<V>> R flatCollect(Function<? super T, ? extends Iterable<V>> function, R target) {
        return (R)this.delegate.asReversed().flatCollect(function, target);
    }

    public T detect(Predicate<? super T> predicate) {
        return (T)this.delegate.asReversed().detect(predicate);
    }

    public <P> T detectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return (T)this.delegate.asReversed().detectWith(predicate, parameter);
    }

    public Optional<T> detectOptional(Predicate<? super T> predicate) {
        return this.delegate.asReversed().detectOptional(predicate);
    }

    public <P> Optional<T> detectWithOptional(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.delegate.asReversed().detectWithOptional(predicate, parameter);
    }

    public T detectIfNone(Predicate<? super T> predicate, Function0<? extends T> function) {
        return (T)this.delegate.asReversed().detectIfNone(predicate, function);
    }

    public <P> T detectWithIfNone(Predicate2<? super T, ? super P> predicate, P parameter, Function0<? extends T> function) {
        return (T)this.delegate.asReversed().detectWithIfNone(predicate, parameter, function);
    }

    public int count(Predicate<? super T> predicate) {
        return this.delegate.asReversed().count(predicate);
    }

    public <P> int countWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.delegate.asReversed().countWith(predicate, parameter);
    }

    public boolean anySatisfy(Predicate<? super T> predicate) {
        return this.delegate.asReversed().anySatisfy(predicate);
    }

    public <P> boolean anySatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.delegate.asReversed().anySatisfyWith(predicate, parameter);
    }

    public boolean allSatisfy(Predicate<? super T> predicate) {
        return this.delegate.asReversed().allSatisfy(predicate);
    }

    public <P> boolean allSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.delegate.asReversed().allSatisfyWith(predicate, parameter);
    }

    public boolean noneSatisfy(Predicate<? super T> predicate) {
        return this.delegate.asReversed().noneSatisfy(predicate);
    }

    public <P> boolean noneSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.delegate.asReversed().noneSatisfyWith(predicate, parameter);
    }

    public <IV> IV injectInto(IV injectedValue, Function2<? super IV, ? super T, ? extends IV> function) {
        return (IV)this.delegate.asReversed().injectInto(injectedValue, function);
    }

    public int injectInto(int injectedValue, IntObjectToIntFunction<? super T> intObjectToIntFunction) {
        return this.delegate.asReversed().injectInto(injectedValue, intObjectToIntFunction);
    }

    public long injectInto(long injectedValue, LongObjectToLongFunction<? super T> longObjectToLongFunction) {
        return this.delegate.asReversed().injectInto(injectedValue, longObjectToLongFunction);
    }

    public double injectInto(double injectedValue, DoubleObjectToDoubleFunction<? super T> doubleObjectToDoubleFunction) {
        return this.delegate.asReversed().injectInto(injectedValue, doubleObjectToDoubleFunction);
    }

    public float injectInto(float injectedValue, FloatObjectToFloatFunction<? super T> floatObjectToFloatFunction) {
        return this.delegate.asReversed().injectInto(injectedValue, floatObjectToFloatFunction);
    }

    public <R extends Collection<T>> R into(R target) {
        return (R)this.delegate.asReversed().into(target);
    }

    public MutableList<T> toList() {
        return this.delegate.asReversed().toList();
    }

    public MutableList<T> toSortedList() {
        return this.delegate.asReversed().toSortedList();
    }

    public MutableList<T> toSortedList(Comparator<? super T> comparator) {
        return this.delegate.asReversed().toSortedList(comparator);
    }

    public MutableSet<T> toSet() {
        return this.delegate.asReversed().toSet();
    }

    public MutableSortedSet<T> toSortedSet() {
        return this.delegate.asReversed().toSortedSet();
    }

    public MutableSortedSet<T> toSortedSet(Comparator<? super T> comparator) {
        return this.delegate.asReversed().toSortedSet(comparator);
    }

    public MutableBag<T> toBag() {
        return this.delegate.asReversed().toBag();
    }

    public MutableSortedBag<T> toSortedBag() {
        return this.delegate.asReversed().toSortedBag();
    }

    public MutableSortedBag<T> toSortedBag(Comparator<? super T> comparator) {
        return this.delegate.asReversed().toSortedBag(comparator);
    }

    public <NK, NV> MutableMap<NK, NV> toMap(Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
        return this.delegate.asReversed().toMap(keyFunction, valueFunction);
    }

    public <NK, NV, R extends Map<NK, NV>> R toMap(Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction, R target) {
        return (R)this.delegate.asReversed().toMap(keyFunction, valueFunction, target);
    }

    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
        return this.delegate.asReversed().toSortedMap(keyFunction, valueFunction);
    }

    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Comparator<? super NK> comparator, Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
        return this.delegate.asReversed().toSortedMap(comparator, keyFunction, valueFunction);
    }

    public <KK extends Comparable<? super KK>, NK, NV> MutableSortedMap<NK, NV> toSortedMapBy(Function<? super NK, KK> sortBy, Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
        return this.delegate.asReversed().toSortedMapBy(sortBy, keyFunction, valueFunction);
    }

    public <NK, NV> MutableBiMap<NK, NV> toBiMap(Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
        return this.delegate.asReversed().toBiMap(keyFunction, valueFunction);
    }

    public LazyIterable<T> asLazy() {
        return LazyIterate.adapt(this);
    }

    public Object[] toArray() {
        return this.delegate.asReversed().toArray();
    }

    public <T> T[] toArray(T[] a) {
        return this.delegate.asReversed().toArray((Object[])a);
    }

    public T min(Comparator<? super T> comparator) {
        return (T)this.delegate.asReversed().min(comparator);
    }

    public T max(Comparator<? super T> comparator) {
        return (T)this.delegate.asReversed().max(comparator);
    }

    public T min() {
        return (T)this.delegate.asReversed().min();
    }

    public T max() {
        return (T)this.delegate.asReversed().max();
    }

    public <V extends Comparable<? super V>> T minBy(Function<? super T, ? extends V> function) {
        return (T)this.delegate.asReversed().toList().minBy(function);
    }

    public <V extends Comparable<? super V>> T maxBy(Function<? super T, ? extends V> function) {
        return (T)this.delegate.asReversed().maxBy(function);
    }

    public long sumOfInt(IntFunction<? super T> intFunction) {
        return this.delegate.asReversed().sumOfInt(intFunction);
    }

    public double sumOfFloat(FloatFunction<? super T> floatFunction) {
        return this.delegate.asReversed().sumOfFloat(floatFunction);
    }

    public long sumOfLong(LongFunction<? super T> longFunction) {
        return this.delegate.asReversed().sumOfLong(longFunction);
    }

    public double sumOfDouble(DoubleFunction<? super T> doubleFunction) {
        return this.delegate.asReversed().sumOfDouble(doubleFunction);
    }

    public <V> ImmutableObjectLongMap<V> sumByInt(Function<? super T, ? extends V> groupBy, IntFunction<? super T> function) {
        ObjectLongMap map = this.delegate.asReversed().sumByInt(groupBy, function);
        return map.toImmutable();
    }

    public <V> ImmutableObjectDoubleMap<V> sumByFloat(Function<? super T, ? extends V> groupBy, FloatFunction<? super T> function) {
        ObjectDoubleMap map = this.delegate.asReversed().sumByFloat(groupBy, function);
        return map.toImmutable();
    }

    public <V> ImmutableObjectLongMap<V> sumByLong(Function<? super T, ? extends V> groupBy, LongFunction<? super T> function) {
        ObjectLongMap map = this.delegate.asReversed().sumByLong(groupBy, function);
        return map.toImmutable();
    }

    public <V> ImmutableObjectDoubleMap<V> sumByDouble(Function<? super T, ? extends V> groupBy, DoubleFunction<? super T> function) {
        ObjectDoubleMap map = this.delegate.asReversed().sumByDouble(groupBy, function);
        return map.toImmutable();
    }

    public String makeString() {
        return this.delegate.asReversed().makeString();
    }

    public String makeString(String separator) {
        return this.delegate.asReversed().makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.asReversed().makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.asReversed().appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.asReversed().appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.asReversed().appendString(appendable, start, separator, end);
    }

    public <V> ImmutableListMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        return this.groupBy(function, FastListMultimap.newMultimap()).toImmutable();
    }

    public <V, R extends MutableMultimap<V, T>> R groupBy(Function<? super T, ? extends V> function, R target) {
        return (R)this.delegate.asReversed().groupBy(function, target);
    }

    public <V> ImmutableListMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        return this.groupByEach(function, FastListMultimap.newMultimap()).toImmutable();
    }

    public <V, R extends MutableMultimap<V, T>> R groupByEach(Function<? super T, ? extends Iterable<V>> function, R target) {
        return (R)this.delegate.asReversed().groupByEach(function, target);
    }

    public <V> ImmutableMap<V, T> groupByUniqueKey(Function<? super T, ? extends V> function) {
        return this.groupByUniqueKey(function, UnifiedMap.newMap(this.size())).toImmutable();
    }

    public <V, R extends MutableMapIterable<V, T>> R groupByUniqueKey(Function<? super T, ? extends V> function, R target) {
        return (R)this.delegate.asReversed().groupByUniqueKey(function, target);
    }

    public <S> ImmutableStack<Pair<T, S>> zip(Iterable<S> that) {
        return ImmutableArrayStack.newStackFromTopToBottom(this.delegate.asReversed().zip(that).toList());
    }

    public <S, R extends Collection<Pair<T, S>>> R zip(Iterable<S> that, R target) {
        return (R)this.delegate.asReversed().zip(that, target);
    }

    public ImmutableStack<Pair<T, Integer>> zipWithIndex() {
        int maxIndex = this.delegate.size() - 1;
        Interval indices = Interval.fromTo(0, maxIndex);
        return ImmutableArrayStack.newStackFromTopToBottom(this.delegate.asReversed().zip((Iterable)indices).toList());
    }

    public <R extends Collection<Pair<T, Integer>>> R zipWithIndex(R target) {
        return (R)this.delegate.asReversed().zipWithIndex(target);
    }

    public ImmutableStack<T> toImmutable() {
        return this;
    }

    public RichIterable<RichIterable<T>> chunk(int size) {
        return this.delegate.asReversed().chunk(size);
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    public ImmutableStack<T> tap(Procedure<? super T> procedure) {
        this.forEach(procedure);
        return this;
    }

    public void each(Procedure<? super T> procedure) {
        this.delegate.reverseForEach(procedure);
    }

    public void forEachWithIndex(ObjectIntProcedure<? super T> objectIntProcedure) {
        this.delegate.asReversed().forEachWithIndex(objectIntProcedure);
    }

    public <P> void forEachWith(Procedure2<? super T, ? super P> procedure, P parameter) {
        this.delegate.asReversed().forEachWith(procedure, parameter);
    }

    public ImmutableStack<T> takeWhile(Predicate<? super T> predicate) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".takeWhile() not implemented yet");
    }

    public ImmutableStack<T> dropWhile(Predicate<? super T> predicate) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".dropWhile() not implemented yet");
    }

    public PartitionImmutableStack<T> partitionWhile(Predicate<? super T> predicate) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".partitionWhile() not implemented yet");
    }

    public ImmutableStack<T> distinct() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".distinct() not implemented yet");
    }

    public <S> boolean corresponds(OrderedIterable<S> other, Predicate2<? super T, ? super S> predicate) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".corresponds() not implemented yet");
    }

    public boolean hasSameElements(OrderedIterable<T> other) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".hasSameElements() not implemented yet");
    }

    public void forEach(int startIndex, int endIndex, Procedure<? super T> procedure) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".forEach() not implemented yet");
    }

    public void forEachWithIndex(int fromIndex, int toIndex, ObjectIntProcedure<? super T> objectIntProcedure) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".forEachWithIndex() not implemented yet");
    }

    public int detectIndex(Predicate<? super T> predicate) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".detectIndex() not implemented yet");
    }

    public Iterator<T> iterator() {
        return this.delegate.asReversed().iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StackIterable)) {
            return false;
        }
        StackIterable that = (StackIterable)o;
        if (that instanceof ImmutableArrayStack) {
            return this.delegate.equals(((ImmutableArrayStack)that).delegate);
        }
        Iterator<T> thisIterator = this.iterator();
        Iterator thatIterator = that.iterator();
        while (thisIterator.hasNext() && thatIterator.hasNext()) {
            if (Objects.equals(thisIterator.next(), thatIterator.next())) continue;
            return false;
        }
        return !thisIterator.hasNext() && !thatIterator.hasNext();
    }

    public String toString() {
        return this.delegate.asReversed().makeString("[", ", ", "]");
    }

    public int hashCode() {
        int hashCode = 1;
        Iterator<T> iterator = this.iterator();
        while (iterator.hasNext()) {
            T each = iterator.next();
            hashCode = 31 * hashCode + (each == null ? 0 : each.hashCode());
        }
        return hashCode;
    }

    private Object writeReplace() {
        return new ImmutableStackSerializationProxy(this);
    }

    private static class ImmutableStackSerializationProxy<T>
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private StackIterable<T> stack;

        public ImmutableStackSerializationProxy() {
        }

        protected ImmutableStackSerializationProxy(StackIterable<T> stack) {
            this.stack = stack;
        }

        @Override
        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.stack.size());
            try {
                this.stack.forEach((Procedure)new CheckedProcedure<T>(){

                    @Override
                    public void safeValue(T object) throws IOException {
                        out.writeObject(object);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            FastList deserializedDelegate = new FastList(size);
            for (int i = 0; i < size; ++i) {
                deserializedDelegate.add(in.readObject());
            }
            this.stack = ImmutableArrayStack.newStackFromTopToBottom(deserializedDelegate);
        }

        protected Object readResolve() {
            return this.stack;
        }
    }
}

