/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.contracts;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.fordiac.ide.contracts.CConnection;
import org.eclipse.fordiac.ide.contracts.CInterval;
import org.eclipse.fordiac.ide.contracts.ContractComponent;
import org.eclipse.fordiac.ide.contracts.ContractIssue;
import org.eclipse.fordiac.ide.contracts.ContractRule;
import org.eclipse.fordiac.ide.contracts.ContractSystem;
import org.eclipse.fordiac.ide.contracts.Messages;

public class StaticContractChecker {
    private final ContractSystem system;
    private final List<ContractComponent> components;
    private final Set<ContractComponent> seenComponents;

    public StaticContractChecker(ContractSystem system, List<ContractComponent> components) {
        this.system = system;
        this.components = components;
        this.seenComponents = new HashSet<ContractComponent>();
    }

    public void checkSystem() {
        for (ContractComponent comp : this.components) {
            int i = comp.getReactions().size() - 1;
            while (i >= 0) {
                this.seenComponents.clear();
                this.resolveReaction(comp.getReactions().get(i));
                --i;
            }
            if (comp.getReactions().isEmpty()) continue;
            this.unresolvedReactionInfo(comp);
        }
        for (ContractComponent comp : this.components) {
            for (CConnection conn : comp.getInputs()) {
                switch (conn.type()) {
                    case NORMAL: {
                        this.checkNormalConnection(comp, conn);
                        break;
                    }
                    case FROM_OUTER: {
                        this.checkFromOuterConnection(comp, conn);
                        break;
                    }
                    case FROM_INNER: {
                        this.checkFromInnerConnection(comp, conn);
                        break;
                    }
                }
            }
        }
    }

    private void resolveReaction(ContractRule reaction) {
        if (!this.seenComponents.add(reaction.getOwner())) {
            return;
        }
        if (reaction.getInputs().size() > 1 || reaction.getOutputs().size() > 1) {
            this.system.warning("Reactions with multiple inputs/outputs not supported yet.", ContractIssue.Code.UNKOWN);
            return;
        }
        ContractComponent comp = reaction.getOwner();
        ContractRule assumption = comp.getAssumptions().get(reaction.getInputs().getFirst());
        if (assumption != null) {
            this.resolveReactionWith(reaction, assumption);
            return;
        }
        boolean resolved = false;
        for (CConnection conn : comp.getInputs()) {
            if (conn.type() == CConnection.Type.FROM_OUTER) {
                ContractRule a = conn.from().getAssumptions().get(conn.fromPort());
                if (a == null) continue;
                if (resolved) {
                    this.multipleResolveError(reaction);
                } else {
                    this.resolveReactionWith(reaction, a);
                }
                resolved = true;
                continue;
            }
            if (conn.type() != CConnection.Type.NORMAL) continue;
            ContractRule g = conn.from().getGuarantees().get(conn.fromPort());
            if (g == null) {
                this.tryRecursiveResolve(conn.from(), conn.fromPort());
            }
            if ((g = conn.from().getGuarantees().get(conn.fromPort())) == null) continue;
            if (resolved) {
                this.multipleResolveError(reaction);
            } else {
                this.resolveReactionWith(reaction, g);
            }
            resolved = true;
        }
    }

    private void tryRecursiveResolve(ContractComponent comp, String port) {
        for (ContractRule reaction : comp.getReactions()) {
            for (String output : reaction.getOutputs()) {
                if (!port.equals(output)) continue;
                this.resolveReaction(reaction);
                return;
            }
        }
    }

    private void resolveReactionWith(ContractRule reaction, ContractRule resolver) {
        if (resolver.getType() == ContractRule.Type.SINGLE_EVENT) {
            this.resolveReactionSingle(reaction, resolver);
        } else if (resolver.getType() == ContractRule.Type.REPETITION) {
            this.resolveReactionRepetition(reaction, resolver);
        }
    }

    private void resolveReactionSingle(ContractRule reaction, ContractRule singleEvent) {
        CInterval interval = reaction.getInterval().add(singleEvent.getInterval());
        for (String output : reaction.getOutputs()) {
            ContractRule rule = new ContractRule(output, interval);
            reaction.getOwner().addRule(rule, this.system);
        }
        reaction.getOwner().getReactions().remove(reaction);
    }

    private void resolveReactionRepetition(ContractRule reaction, ContractRule repetition) {
        CInterval interval = repetition.getInterval();
        CInterval offset = reaction.getInterval().add(repetition.getOffset());
        for (String output : reaction.getOutputs()) {
            ContractRule rule = new ContractRule(output, interval, offset, repetition.getJitter());
            reaction.getOwner().addRule(rule, this.system);
        }
        reaction.getOwner().getReactions().remove(reaction);
    }

    private void checkNormalConnection(ContractComponent comp, CConnection conn) {
        if (comp == conn.from()) {
            this.checkDirectInnerConnection(comp, conn);
        }
        ContractRule assumption = comp.getAssumptions().get(conn.toPort());
        ContractRule guarantee = conn.from().getGuarantees().get(conn.fromPort());
        if (assumption != null && guarantee != null) {
            this.checkRules(assumption, guarantee);
        }
    }

    private void checkDirectInnerConnection(ContractComponent comp, CConnection conn) {
        ContractRule assumption = comp.getAssumptions().get(conn.fromPort());
        ContractRule guarantee = comp.getGuarantees().get(conn.toPort());
        if (assumption != null && guarantee != null) {
            this.checkRules(guarantee, assumption);
        }
    }

    private void checkFromOuterConnection(ContractComponent comp, CConnection conn) {
        ContractRule assumptionInner = comp.getAssumptions().get(conn.toPort());
        ContractRule assumptionOuter = conn.from().getAssumptions().get(conn.fromPort());
        if (assumptionInner != null && assumptionOuter != null) {
            this.checkRules(assumptionInner, assumptionOuter);
        }
    }

    private void checkFromInnerConnection(ContractComponent comp, CConnection conn) {
        ContractRule guaranteeOuter = comp.getGuarantees().get(conn.toPort());
        ContractRule guaranteeInner = conn.from().getGuarantees().get(conn.fromPort());
        if (guaranteeOuter != null && guaranteeInner != null) {
            this.checkRules(guaranteeOuter, guaranteeInner);
        }
    }

    private void checkRules(ContractRule weaker, ContractRule stronger) {
        if (weaker.getType() == ContractRule.Type.SINGLE_EVENT) {
            if (stronger.getType() == ContractRule.Type.SINGLE_EVENT) {
                if (this.checkSingleEvents(weaker, stronger)) {
                    if (weaker.isFulFilled()) {
                        this.multipleFulfillsError(weaker);
                    }
                    weaker.setFulFilled(true);
                }
            } else if (stronger.getType() == ContractRule.Type.REPETITION) {
                this.contractRuleTypeError(weaker, stronger);
            }
        } else if (weaker.getType() == ContractRule.Type.REPETITION) {
            if (stronger.getType() == ContractRule.Type.REPETITION) {
                if (this.checkRepetitions(weaker, stronger)) {
                    if (weaker.isFulFilled()) {
                        this.multipleFulfillsError(weaker);
                    }
                    weaker.setFulFilled(true);
                }
            } else if (stronger.getType() == ContractRule.Type.SINGLE_EVENT) {
                this.contractRuleTypeError(weaker, stronger);
            }
        }
    }

    private boolean checkSingleEvents(ContractRule weaker, ContractRule stronger) {
        if (!weaker.getInterval().contains(stronger.getInterval())) {
            this.system.error(Messages.ContractSingleEventMatchError.formatted(weaker.getOwner().getName(), weaker.getSinglePort(), weaker.getInterval(), stronger.getOwner().getName(), stronger.getInterval()), ContractIssue.Code.SINGLE_EVENT_MATCH);
            return false;
        }
        return true;
    }

    private boolean checkRepetitions(ContractRule weaker, ContractRule stronger) {
        CInterval sI;
        CInterval sO;
        CInterval wO = weaker.getOffset().addJitter(weaker.getJitter());
        if (!wO.contains(sO = stronger.getOffset().addJitter(stronger.getJitter()))) {
            this.system.error(Messages.ContractRepetitionOffsetMatchError.formatted(weaker.getOwner().getName(), weaker.getSinglePort(), wO, stronger.getOwner().getName(), sO), ContractIssue.Code.REPETITION_MATCH);
            return false;
        }
        CInterval wI = weaker.getInterval().add(weaker.getOffset()).addJitter(weaker.getJitter());
        if (!wI.contains(sI = stronger.getInterval().add(stronger.getOffset()).addJitter(stronger.getJitter()))) {
            this.system.error(Messages.ContractRepetitionIntervalMatchError.formatted(weaker.getOwner().getName(), weaker.getSinglePort(), wI, stronger.getOwner().getName(), sI), ContractIssue.Code.REPETITION_MATCH);
            return false;
        }
        return true;
    }

    private void contractRuleTypeError(ContractRule r1, ContractRule r2) {
        this.system.error(Messages.ContractRuleTypeError.formatted(new Object[]{r1.getOwner().getName(), r1.getSinglePort(), r1.getType(), r2.getOwner().getName(), r2.getType()}), ContractIssue.Code.TYPE_MATCH);
    }

    private void unresolvedReactionInfo(ContractComponent comp) {
        this.system.info(Messages.ContractUnresolvedReactionInfo.formatted(comp.getName()), ContractIssue.Code.UNRESOLVED_REACTION);
    }

    private void multipleFulfillsError(ContractRule rule) {
        this.system.error(Messages.ContractMultipleFulfillError.formatted(rule.getOwner().getName(), rule.getSinglePort()), ContractIssue.Code.MULTIPLE_FULFILL);
    }

    private void multipleResolveError(ContractRule rule) {
        this.system.error(Messages.ContractMultipleResolveError.formatted(rule.getOwner().getName()), ContractIssue.Code.MULTIPLE_RESOLVE);
    }
}

