/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.ui.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.fordiac.ide.structuredtextcore.ui.refactoring.ExtractCallableRefactoring;
import org.eclipse.fordiac.ide.structuredtextcore.ui.refactoring.Messages;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class ExtractCallableWizardPage
extends UserInputWizardPage {
    private final ExtractCallableRefactoring refactoring;
    private Text nameText;

    public ExtractCallableWizardPage(ExtractCallableRefactoring refactoring) {
        super(refactoring.getName());
        this.refactoring = refactoring;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        this.initializeDialogUnits((Control)composite);
        this.createNameField(composite);
        this.setControl((Control)composite);
    }

    protected void createNameField(Composite parent) {
        Label nameLabel = new Label(parent, 0);
        nameLabel.setText(Messages.ExtractCallableWizardPage_NameField);
        this.nameText = new Text(parent, 2048);
        this.nameText.setText(this.refactoring.getCallableName());
        this.nameText.addModifyListener(e -> {
            this.refactoring.setCallableName(this.nameText.getText());
            this.validatePage();
        });
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.nameText);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.nameText.setFocus();
        }
        super.setVisible(visible);
    }

    protected void validatePage() {
        try {
            this.setPageComplete(this.refactoring.checkAllConditions((IProgressMonitor)new NullProgressMonitor()));
        }
        catch (CoreException | OperationCanceledException e) {
            this.setPageComplete(RefactoringStatus.createFatalErrorStatus((String)e.getMessage()));
        }
    }
}

