/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.xtext.parsetree.reconstr.SerializerOptions;
import org.eclipse.xtext.resource.XtextResource;

public class SaveOptions {
    protected static final String KEY = SaveOptions.class.getName();
    private final boolean formatting;
    @Deprecated
    private final boolean validating;

    protected SaveOptions(boolean formatting, boolean validating) {
        this.formatting = formatting;
        this.validating = validating;
    }

    public static SaveOptions getOptions(Map<?, ?> saveOptions) {
        if (saveOptions == null || saveOptions.isEmpty()) {
            return SaveOptions.defaultOptions();
        }
        if (saveOptions.containsKey(KEY)) {
            return (SaveOptions)saveOptions.get(KEY);
        }
        if (saveOptions.containsKey(XtextResource.OPTION_SERIALIZATION_OPTIONS)) {
            return ((SerializerOptions)saveOptions.get(XtextResource.OPTION_SERIALIZATION_OPTIONS)).toSaveOptions();
        }
        if (Boolean.TRUE.equals(saveOptions.get(XtextResource.OPTION_FORMAT))) {
            return SaveOptions.newBuilder().format().getOptions();
        }
        return SaveOptions.defaultOptions();
    }

    public void addTo(Map<Object, Object> saveOptions) {
        saveOptions.put(KEY, this);
    }

    public Map<Object, Object> toOptionsMap() {
        HashMap<Object, Object> result = new HashMap<Object, Object>(3);
        this.addTo(result);
        return result;
    }

    public boolean isFormatting() {
        return this.formatting;
    }

    @Deprecated
    public boolean isValidating() {
        return this.validating;
    }

    public String toString() {
        return "SaveOptions [formatting=" + this.formatting + ", validating=" + this.validating + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.formatting ? 1231 : 1237);
        result = 31 * result + (this.validating ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SaveOptions other = (SaveOptions)obj;
        if (this.formatting != other.formatting) {
            return false;
        }
        return this.validating == other.validating;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static SaveOptions defaultOptions() {
        return SaveOptions.newBuilder().getOptions();
    }

    public static class Builder {
        private boolean formatting = false;
        private boolean validating = true;

        protected Builder() {
        }

        public Builder format() {
            this.formatting = true;
            return this;
        }

        @Deprecated
        public Builder noValidation() {
            this.validating = false;
            return this;
        }

        public SaveOptions getOptions() {
            return new SaveOptions(this.formatting, this.validating);
        }
    }
}

