/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ide.contentassist;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.common.types.descriptions.ClasspathScanner;
import org.eclipse.xtext.common.types.descriptions.ITypeDescriptor;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistEntry;
import org.eclipse.xtext.ide.editor.contentassist.IIdeContentProposalAcceptor;
import org.eclipse.xtext.ide.editor.contentassist.IdeContentProposalCreator;
import org.eclipse.xtext.ide.editor.contentassist.IdeContentProposalPriorities;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ReplaceRegion;
import org.eclipse.xtext.xbase.ide.contentassist.IIdeTypesProposalProvider;
import org.eclipse.xtext.xbase.ide.contentassist.XbaseIdeContentProposalPriorities;
import org.eclipse.xtext.xbase.imports.IImportsConfiguration;
import org.eclipse.xtext.xbase.imports.ImportSectionRegionUtil;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xtype.XImportSection;
import org.eclipse.xtext.xtype.XtypePackage;

public class ClasspathBasedIdeTypesProposalProvider
implements IIdeTypesProposalProvider {
    @Inject
    private ClassLoader classLoader;
    @Inject
    private ClasspathScanner classpathScanner;
    @Inject
    private IdeContentProposalCreator proposalCreator;
    @Inject
    private IdeContentProposalPriorities proposalPriorities;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private IImportsConfiguration importsConfiguration;
    @Inject
    private ImportSectionRegionUtil importSectionRegionUtil;

    @Override
    public void createTypeProposals(EReference reference, ContentAssistContext context, Predicate<? super ITypeDescriptor> filter, IIdeContentProposalAcceptor acceptor) {
        ITextRegion importSectionRegion = null;
        XImportSection importSection = null;
        if (!this.isImportDeclaration(reference, context)) {
            importSection = this.importsConfiguration.getImportSection(context.getResource());
            importSectionRegion = this.importSectionRegionUtil.computeRegion(context.getResource());
        }
        for (ITypeDescriptor typeDesc : this.getTypeDescriptors(context)) {
            if (!acceptor.canAcceptMoreProposals()) {
                return;
            }
            if (!this.canPropose(typeDesc, context, filter)) continue;
            ContentAssistEntry entry = this.createProposal(reference, typeDesc, context, importSection, importSectionRegion);
            int priority = ((XbaseIdeContentProposalPriorities)this.proposalPriorities).getTypeRefPriority(typeDesc, entry);
            acceptor.accept(entry, priority);
        }
    }

    protected Iterable<ITypeDescriptor> getTypeDescriptors(ContentAssistContext context) {
        Iterable bootClasspath = this.classpathScanner.getBootClasspathDescriptors((Collection)Lists.newArrayList((Object[])new String[]{"java"}));
        Iterable appClasspath = this.classpathScanner.getDescriptors(this.getClassLoader(context), Collections.emptyList());
        return Iterables.concat((Iterable)bootClasspath, (Iterable)appClasspath);
    }

    protected ClassLoader getClassLoader(ContentAssistContext context) {
        Object ctx;
        ResourceSet resourceSet = context.getResource().getResourceSet();
        if (resourceSet instanceof XtextResourceSet && (ctx = ((XtextResourceSet)resourceSet).getClasspathURIContext()) != null) {
            if (ctx instanceof Class) {
                return ((Class)ctx).getClassLoader();
            }
            if (ctx instanceof ClassLoader) {
                return (ClassLoader)ctx;
            }
            return ctx.getClass().getClassLoader();
        }
        return this.classLoader;
    }

    protected boolean canPropose(ITypeDescriptor typeDesc, ContentAssistContext context, Predicate<? super ITypeDescriptor> filter) {
        return this.isVisible(typeDesc, context) && filter.apply((Object)typeDesc);
    }

    protected boolean isVisible(ITypeDescriptor typeDesc, ContentAssistContext context) {
        return Modifier.isPublic(typeDesc.getModifiers());
    }

    protected ContentAssistEntry createProposal(EReference reference, ITypeDescriptor typeDesc, ContentAssistContext context, XImportSection importSection, ITextRegion importSectionRegion) {
        boolean importDecl = this.isImportDeclaration(reference, context);
        String qualifiedName = this.qualifiedNameConverter.toString(typeDesc.getQualifiedName());
        String proposal = importDecl ? qualifiedName : typeDesc.getSimpleName();
        return this.proposalCreator.createProposal(proposal, context, it -> {
            it.setKind("REFERENCE");
            if (importDecl) {
                it.setLabel(typeDesc.getSimpleName());
                it.setDescription(proposal);
            } else {
                it.setDescription(qualifiedName);
                if (importSectionRegion != null && this.isImportDeclarationRequired(typeDesc, qualifiedName, context, importSection)) {
                    this.addImportDeclaration((ContentAssistEntry)it, importSectionRegion, typeDesc, qualifiedName, context);
                }
            }
        });
    }

    protected boolean isImportDeclaration(EReference reference, ContentAssistContext context) {
        return XtypePackage.Literals.XIMPORT_DECLARATION__IMPORTED_TYPE.equals(reference);
    }

    protected boolean isImportDeclarationRequired(ITypeDescriptor typeDesc, String qualifiedName, ContentAssistContext context, XImportSection importSection) {
        return !(typeDesc.getName().startsWith("java.lang") && typeDesc.getName().lastIndexOf(46) == "java.lang".length() || importSection != null && IterableExtensions.exists((Iterable)importSection.getImportDeclarations(), it -> {
            String importFqn = null;
            if (it.getImportedType() != null) {
                importFqn = it.getImportedType().getQualifiedName();
            }
            return Objects.equals(importFqn, qualifiedName);
        }));
    }

    protected boolean addImportDeclaration(ContentAssistEntry entry, ITextRegion importSectionRegion, ITypeDescriptor typeDesc, String qualifiedName, ContentAssistContext context) {
        int insertionOffset = importSectionRegion.getEndOffset();
        String declaration = "\nimport " + qualifiedName;
        return entry.getTextReplacements().add(new ReplaceRegion(insertionOffset, 0, declaration));
    }
}

