/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.ui.providers;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IFindReplaceTargetExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;

public final class SourceViewerColorProvider {
    public static void initializeSourceViewerColors(ISourceViewer viewer) {
        IPreferenceStore store = SourceViewerColorProvider.getPreferenceStore();
        if (store != null) {
            StyledText styledText = viewer.getTextWidget();
            Color color = store.getBoolean("AbstractTextEditor.Color.Foreground.SystemDefault") ? null : SourceViewerColorProvider.getColor("AbstractTextEditor.Color.Foreground");
            styledText.setForeground(color);
            color = store.getBoolean("AbstractTextEditor.Color.Background.SystemDefault") ? null : SourceViewerColorProvider.getColor("AbstractTextEditor.Color.Background");
            styledText.setBackground(color);
            color = store.getBoolean("AbstractTextEditor.Color.SelectionForeground.SystemDefault") ? null : SourceViewerColorProvider.getColor("AbstractTextEditor.Color.SelectionForeground");
            styledText.setSelectionForeground(color);
            color = store.getBoolean("AbstractTextEditor.Color.SelectionBackground.SystemDefault") ? null : SourceViewerColorProvider.getColor("AbstractTextEditor.Color.SelectionBackground");
            styledText.setSelectionBackground(color);
            IFindReplaceTarget target = viewer.getFindReplaceTarget();
            if (target instanceof IFindReplaceTargetExtension) {
                ((IFindReplaceTargetExtension)target).setScopeHighlightColor(SourceViewerColorProvider.getColor("AbstractTextEditor.Color.FindScope"));
            }
        }
    }

    private static Color getColor(String symbolicName) {
        Color color = JFaceResources.getColorRegistry().get(symbolicName);
        if (color == null) {
            color = SourceViewerColorProvider.createColor(symbolicName);
        }
        return color;
    }

    private static IPreferenceStore getPreferenceStore() {
        return EditorsPlugin.getDefault().getPreferenceStore();
    }

    private static Color createColor(String symbolicName) {
        IPreferenceStore store = SourceViewerColorProvider.getPreferenceStore();
        if (store.contains(symbolicName)) {
            RGB rgb;
            RGB rGB = rgb = store.isDefault(symbolicName) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)symbolicName) : PreferenceConverter.getColor((IPreferenceStore)store, (String)symbolicName);
            if (rgb != null) {
                JFaceResources.getColorRegistry().put(symbolicName, rgb);
                return JFaceResources.getColorRegistry().get(symbolicName);
            }
        }
        return null;
    }

    private SourceViewerColorProvider() {
        throw new AssertionError();
    }
}

