/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.tree;

import java.io.PrintStream;
import java.util.Hashtable;
import org.glassfish.rmic.tools.asm.Assembler;
import org.glassfish.rmic.tools.asm.Label;
import org.glassfish.rmic.tools.java.ClassDefinition;
import org.glassfish.rmic.tools.java.ClassNotFound;
import org.glassfish.rmic.tools.java.Environment;
import org.glassfish.rmic.tools.java.Type;
import org.glassfish.rmic.tools.tree.BinaryExpression;
import org.glassfish.rmic.tools.tree.Context;
import org.glassfish.rmic.tools.tree.Expression;
import org.glassfish.rmic.tools.tree.TypeExpression;
import org.glassfish.rmic.tools.tree.Vset;

public class InstanceOfExpression
extends BinaryExpression {
    public InstanceOfExpression(long where, Expression left, Expression right) {
        super(25, where, Type.tBoolean, left, right);
    }

    @Override
    public Vset checkValue(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp) {
        vset = this.left.checkValue(env, ctx, vset, exp);
        this.right = new TypeExpression(this.right.where, this.right.toType(env, ctx));
        if (this.right.type.isType(13) || this.left.type.isType(13)) {
            return vset;
        }
        if (!this.right.type.inMask(1536)) {
            env.error(this.right.where, "invalid.arg.type", this.right.type, opNames[this.op]);
            return vset;
        }
        try {
            if (!env.explicitCast(this.left.type, this.right.type)) {
                env.error(this.where, "invalid.instanceof", this.left.type, this.right.type);
            }
        }
        catch (ClassNotFound e) {
            env.error(this.where, "class.not.found", e.name, opNames[this.op]);
        }
        return vset;
    }

    @Override
    public Expression inline(Environment env, Context ctx) {
        return this.left.inline(env, ctx);
    }

    @Override
    public Expression inlineValue(Environment env, Context ctx) {
        this.left = this.left.inlineValue(env, ctx);
        return this;
    }

    @Override
    public int costInline(int thresh, Environment env, Context ctx) {
        if (ctx == null) {
            return 1 + this.left.costInline(thresh, env, ctx);
        }
        ClassDefinition sourceClass = ctx.field.getClassDefinition();
        try {
            if (this.right.type.isType(9) || sourceClass.permitInlinedAccess(env, env.getClassDeclaration(this.right.type))) {
                return 1 + this.left.costInline(thresh, env, ctx);
            }
        }
        catch (ClassNotFound classNotFound) {
            // empty catch block
        }
        return thresh;
    }

    @Override
    public void codeValue(Environment env, Context ctx, Assembler asm) {
        this.left.codeValue(env, ctx, asm);
        if (this.right.type.isType(10)) {
            asm.add(this.where, 193, env.getClassDeclaration(this.right.type));
        } else {
            asm.add(this.where, 193, this.right.type);
        }
    }

    @Override
    void codeBranch(Environment env, Context ctx, Assembler asm, Label lbl, boolean whenTrue) {
        this.codeValue(env, ctx, asm);
        asm.add(this.where, whenTrue ? 154 : 153, lbl, whenTrue);
    }

    @Override
    public void code(Environment env, Context ctx, Assembler asm) {
        this.left.code(env, ctx, asm);
    }

    @Override
    public void print(PrintStream out) {
        out.print("(" + opNames[this.op] + " ");
        this.left.print(out);
        out.print(" ");
        if (this.right.op == 147) {
            out.print(this.right.type.toString());
        } else {
            this.right.print(out);
        }
        out.print(")");
    }
}

