/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.remote;

import java.util.ArrayList;
import java.util.List;

public class Metrix {
    private static final Metrix instance = new Metrix();
    private static final long timestamp = System.currentTimeMillis();
    private List<Stat> list = new ArrayList<Stat>(64);

    private Metrix() {
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append("duration, delta, event\n");
        long lastTS = timestamp;
        for (Stat stat : this.list) {
            res.append(stat.timestamp - timestamp).append(", ");
            res.append(stat.timestamp - lastTS).append(", ");
            res.append(stat.message);
            if (stat.param != null) {
                res.append(" - ").append(stat.param);
            }
            res.append('\n');
            lastTS = stat.timestamp;
        }
        return res.toString();
    }

    public static void event(String message) {
        Metrix.instance.list.add(new Stat(message, null));
    }

    public static void event(String message, String param) {
        Metrix.instance.list.add(new Stat(message, null));
    }

    public static Metrix getInstance() {
        return instance;
    }

    public static class Stat {
        public final long timestamp = System.currentTimeMillis();
        public final String message;
        public final String param;

        public Stat(String message, String param) {
            this.message = message;
            this.param = param;
        }
    }
}

