/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import java.beans.PropertyVetoException;
import java.util.List;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Element;

public interface JvmOptionBag
extends ConfigBeanProxy {
    @Element
    public List<String> getJvmOptions();

    public void setJvmOptions(List<String> var1) throws PropertyVetoException;

    default public int getXmxMegs() {
        return this.getMemory("-Xmx");
    }

    default public int getXmsMegs() {
        return this.getMemory("-Xms");
    }

    default public boolean contains(String option) {
        return this.getJvmOptions().contains(option);
    }

    default public String getStartingWith(String start) {
        for (String option : this.getJvmOptions()) {
            if (!option.startsWith(start)) continue;
            return option;
        }
        return null;
    }

    private int getMemory(String which) {
        List<String> options = this.getJvmOptions();
        for (String option : options) {
            if (!option.contains(which)) continue;
            return JvmOptionBag.toMeg(option, which);
        }
        return -1;
    }

    public static int toMeg(String whole, String which) {
        String size = whole.substring(which.length());
        char unit = size.charAt(size.length() - 1);
        try {
            int sizeInMegabytes = Integer.parseInt(size.substring(0, size.length() - 1));
            if (unit == 'g' || unit == 'G') {
                return sizeInMegabytes * 1024;
            }
            if (unit == 'm' || unit == 'M') {
                return sizeInMegabytes;
            }
            if (unit == 'k' || unit == 'K') {
                return sizeInMegabytes / 1024;
            }
            return Integer.parseInt(size) / 0x100000;
        }
        catch (RuntimeException e) {
            return -1;
        }
    }
}

