/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.sequence.persistent;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.rx.rm.runtime.sequence.persistent.DataSourceProvider;
import com.sun.xml.ws.rx.rm.runtime.sequence.persistent.PersistenceException;
import jakarta.transaction.SystemException;
import jakarta.transaction.UserTransaction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import javax.naming.InitialContext;
import javax.naming.NamingException;

final class ConnectionManager {
    private static final Logger LOGGER = Logger.getLogger(ConnectionManager.class);
    private final DataSourceProvider dataSourceProvider;

    public static ConnectionManager getInstance(DataSourceProvider dataSourceProvider) {
        return new ConnectionManager(dataSourceProvider);
    }

    private ConnectionManager(DataSourceProvider dataSourceProvider) {
        this.dataSourceProvider = dataSourceProvider;
    }

    Connection getConnection() throws PersistenceException {
        try {
            Connection connection = this.dataSourceProvider.getDataSource().getConnection();
            connection.setAutoCommit(false);
            return connection;
        }
        catch (SQLException ex) {
            throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException("Unable to setup required JDBC connection parameters", ex))));
        }
    }

    PreparedStatement prepareStatement(Connection sqlConnection, String sqlStatement, boolean isItForExecuteUpdate) throws SQLException {
        LOGGER.finer(String.format("Preparing SQL statement:\n%s", sqlStatement));
        PreparedStatement resultPS = isItForExecuteUpdate ? sqlConnection.prepareStatement(sqlStatement) : sqlConnection.prepareStatement(sqlStatement, 1004, 1007);
        return resultPS;
    }

    void recycle(ResultSet ... resources) {
        for (ResultSet resource : resources) {
            if (resource == null) continue;
            try {
                resource.close();
            }
            catch (SQLException ex) {
                LOGGER.logException((Throwable)ex, Level.WARNING);
            }
        }
    }

    void recycle(PreparedStatement ... resources) {
        for (PreparedStatement resource : resources) {
            if (resource == null) continue;
            try {
                resource.close();
            }
            catch (SQLException ex) {
                LOGGER.logException((Throwable)ex, Level.WARNING);
            }
        }
    }

    void recycle(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException ex) {
                LOGGER.logException((Throwable)ex, Level.WARNING);
            }
        }
    }

    void rollback(Connection sqlConnection) {
        this.rollback(sqlConnection, true);
    }

    void rollback(Connection sqlConnection, boolean markRollbackForXA) {
        if (this.isDistributedTransactionInUse()) {
            try {
                if (markRollbackForXA) {
                    this.getUserTransaction().setRollbackOnly();
                }
            }
            catch (SystemException | IllegalStateException ise) {
                LOGGER.warning("Was not able to mark distributed transaction for rollback", ise);
            }
        } else {
            try {
                sqlConnection.rollback();
            }
            catch (SQLException ex) {
                LOGGER.warning("Unexpected exception occured while performing transaction rollback", (Throwable)ex);
            }
        }
    }

    void commit(Connection sqlConnection) throws PersistenceException {
        if (!this.isDistributedTransactionInUse()) {
            try {
                sqlConnection.commit();
            }
            catch (SQLException ex) {
                throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException("Unexpected exception occured while performing transaction commit", ex))));
            }
        }
    }

    private boolean isDistributedTransactionInUse() {
        boolean result = false;
        int status = 6;
        try {
            UserTransaction userTransaction = this.getUserTransaction();
            if (userTransaction != null) {
                status = userTransaction.getStatus();
            }
        }
        catch (SystemException se) {
            LOGGER.warning("Not able to determine if distributed transaction is in use", (Throwable)se);
        }
        if (status != 6) {
            result = true;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Determined that distributed transaction is in use. Status code: " + status);
            }
        }
        return result;
    }

    private UserTransaction getUserTransaction() {
        UserTransaction userTransaction = null;
        try {
            InitialContext initialContext = new InitialContext();
            userTransaction = (UserTransaction)initialContext.lookup("java:comp/UserTransaction");
        }
        catch (NamingException ne) {
            LOGGER.warning("Not able to lookup UserTransaction from InitialContext", (Throwable)ne);
        }
        return userTransaction;
    }
}

