/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.wasp.compiler;

import jakarta.servlet.jsp.tagext.TagAttributeInfo;
import jakarta.servlet.jsp.tagext.TagExtraInfo;
import jakarta.servlet.jsp.tagext.TagFileInfo;
import jakarta.servlet.jsp.tagext.TagInfo;
import jakarta.servlet.jsp.tagext.TagLibraryInfo;
import jakarta.servlet.jsp.tagext.TagVariableInfo;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.glassfish.wasp.Constants;
import org.glassfish.wasp.JspCompilationContext;
import org.glassfish.wasp.WaspException;
import org.glassfish.wasp.compiler.Compiler;
import org.glassfish.wasp.compiler.ErrorDispatcher;
import org.glassfish.wasp.compiler.JspRuntimeContext;
import org.glassfish.wasp.compiler.JspUtil;
import org.glassfish.wasp.compiler.Node;
import org.glassfish.wasp.compiler.PageInfo;
import org.glassfish.wasp.compiler.ParserController;
import org.glassfish.wasp.compiler.WaspTagInfo;
import org.glassfish.wasp.runtime.JspSourceDependent;
import org.glassfish.wasp.servlet.JspServletWrapper;

class TagFileProcessor {
    private ArrayList<Compiler> tempCompilers;

    TagFileProcessor() {
    }

    public static TagInfo parseTagFileDirectives(ParserController parserController, String name, String path, TagLibraryInfo tagLibInfo) throws WaspException {
        ErrorDispatcher err = parserController.getCompiler().getErrorDispatcher();
        Node.Nodes page = null;
        try {
            page = parserController.parseTagFileDirectives(path);
        }
        catch (FileNotFoundException e) {
            err.jspError("jsp.error.file.not.found", path);
        }
        catch (IOException e) {
            err.jspError("jsp.error.file.not.found", path);
        }
        TagFileDirectiveVisitor tagFileVisitor = new TagFileDirectiveVisitor(parserController.getCompiler(), tagLibInfo, name, path);
        page.visit(tagFileVisitor);
        tagFileVisitor.postCheck();
        return tagFileVisitor.getTagInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> loadTagFile(Compiler compiler, String tagFilePath, TagInfo tagInfo, PageInfo parentPageInfo) throws WaspException {
        JspRuntimeContext runtimeContext;
        JspCompilationContext compilationContext = compiler.getCompilationContext();
        JspRuntimeContext jspRuntimeContext = runtimeContext = compilationContext.getRuntimeContext();
        synchronized (jspRuntimeContext) {
            Class<?> tagClazz;
            JspServletWrapper wrapper = runtimeContext.getWrapper(tagFilePath);
            if (wrapper == null) {
                wrapper = new JspServletWrapper(compilationContext.getServletContext(), compilationContext.getOptions(), tagFilePath, tagInfo, compilationContext.getRuntimeContext(), compilationContext.getTagFileJarUrls().get(tagFilePath));
                runtimeContext.addWrapper(tagFilePath, wrapper);
                wrapper.getJspEngineContext().setClassLoader(compilationContext.getClassLoader());
                wrapper.getJspEngineContext().setClassPath(compilationContext.getClassPath());
            } else {
                wrapper.getJspEngineContext().setTagInfo(tagInfo);
            }
            int tripCount = wrapper.incTripCount();
            try {
                if (tripCount > 0) {
                    JspServletWrapper tempWrapper = new JspServletWrapper(compilationContext.getServletContext(), compilationContext.getOptions(), tagFilePath, tagInfo, compilationContext.getRuntimeContext(), compilationContext.getTagFileJarUrls().get(tagFilePath));
                    tagClazz = tempWrapper.loadTagFilePrototype();
                    this.tempCompilers.add(tempWrapper.getJspEngineContext().getCompiler());
                } else {
                    tagClazz = wrapper.loadTagFile();
                }
            }
            finally {
                wrapper.decTripCount();
            }
            try {
                Object tagIns = tagClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (tagIns instanceof JspSourceDependent) {
                    for (String dependant : ((JspSourceDependent)tagIns).getDependants()) {
                        parentPageInfo.addDependant(dependant);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return tagClazz;
        }
    }

    public void loadTagFiles(Compiler compiler, Node.Nodes page) throws WaspException {
        this.tempCompilers = new ArrayList();
        page.visit(new TagFileLoaderVisitor(compiler));
    }

    public void removeProtoTypeFiles(String classFileName) {
        for (Compiler compiler : this.tempCompilers) {
            if (classFileName == null) {
                compiler.removeGeneratedClassFiles();
                continue;
            }
            if (!classFileName.equals(compiler.getCompilationContext().getClassFileName())) continue;
            compiler.removeGeneratedClassFiles();
            this.tempCompilers.remove(compiler);
            return;
        }
    }

    private class TagFileLoaderVisitor
    extends Node.Visitor {
        private Compiler compiler;
        private PageInfo pageInfo;

        TagFileLoaderVisitor(Compiler compiler) {
            this.compiler = compiler;
            this.pageInfo = compiler.getPageInfo();
        }

        @Override
        public void visit(Node.CustomTag customTag) throws WaspException {
            TagFileInfo tagFileInfo = customTag.getTagFileInfo();
            if (tagFileInfo != null) {
                String tagFilePath = tagFileInfo.getPath();
                if (tagFilePath.startsWith("/META-INF/")) {
                    String[] location = this.compiler.getCompilationContext().getTldLocation(tagFileInfo.getTagInfo().getTagLibrary().getURI());
                    this.pageInfo.addDependant("jar:" + location[0] + "!/" + location[1]);
                    this.pageInfo.addDependant("jar:" + location[0] + "!" + tagFilePath);
                } else {
                    this.pageInfo.addDependant(tagFilePath);
                }
                customTag.setTagHandlerClass(TagFileProcessor.this.loadTagFile(this.compiler, tagFilePath, customTag.getTagInfo(), this.pageInfo));
            }
            this.visitBody(customTag);
        }
    }

    private static class TagFileDirectiveVisitor
    extends Node.Visitor {
        private static final JspUtil.ValidAttribute[] tagDirectiveAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("display-name"), new JspUtil.ValidAttribute("body-content"), new JspUtil.ValidAttribute("dynamic-attributes"), new JspUtil.ValidAttribute("small-icon"), new JspUtil.ValidAttribute("large-icon"), new JspUtil.ValidAttribute("description"), new JspUtil.ValidAttribute("example"), new JspUtil.ValidAttribute("pageEncoding"), new JspUtil.ValidAttribute("language"), new JspUtil.ValidAttribute("import"), new JspUtil.ValidAttribute("isELIgnored"), new JspUtil.ValidAttribute("deferredSyntaxAllowedAsLiteral"), new JspUtil.ValidAttribute("trimDirectiveWhitespaces"), new JspUtil.ValidAttribute("errorOnELNotFound")};
        private static final JspUtil.ValidAttribute[] attributeDirectiveAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("name", true), new JspUtil.ValidAttribute("required"), new JspUtil.ValidAttribute("fragment"), new JspUtil.ValidAttribute("rtexprvalue"), new JspUtil.ValidAttribute("type"), new JspUtil.ValidAttribute("description"), new JspUtil.ValidAttribute("deferredValue"), new JspUtil.ValidAttribute("deferredValueType"), new JspUtil.ValidAttribute("deferredMethod"), new JspUtil.ValidAttribute("deferredMethodSignature")};
        private static final JspUtil.ValidAttribute[] variableDirectiveAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("name-given"), new JspUtil.ValidAttribute("name-from-attribute"), new JspUtil.ValidAttribute("alias"), new JspUtil.ValidAttribute("variable-class"), new JspUtil.ValidAttribute("scope"), new JspUtil.ValidAttribute("declare"), new JspUtil.ValidAttribute("description")};
        private ErrorDispatcher err;
        private TagLibraryInfo tagLibInfo;
        private String name;
        private String path;
        private TagExtraInfo tei;
        private String bodycontent;
        private String description;
        private String displayName;
        private String smallIcon;
        private String largeIcon;
        private String dynamicAttrsMapName;
        private String example;
        private List<TagAttributeInfo> tagAttributes;
        private List<TagVariableInfo> tagVariables;
        private HashMap<String, NameEntry> nameTable = new HashMap();
        private HashMap<String, NameEntry> nameFromTable = new HashMap();
        private Double jakartaPagesVersionDouble;

        public TagFileDirectiveVisitor(Compiler compiler, TagLibraryInfo tagLibInfo, String name, String path) {
            this.err = compiler.getErrorDispatcher();
            this.tagLibInfo = tagLibInfo;
            this.name = name;
            this.path = path;
            this.tagAttributes = new ArrayList<TagAttributeInfo>();
            this.tagVariables = new ArrayList<TagVariableInfo>();
            this.jakartaPagesVersionDouble = Double.valueOf(tagLibInfo.getRequiredVersion());
        }

        @Override
        public void visit(Node.JspRoot root) throws WaspException {
            String jspRootVersion = root.getTextAttribute("version");
            if (jspRootVersion == null) {
                this.err.jspError((Node)root, "jsp.error.mandatory.attribute", root.getQName(), "version");
            }
            if (!jspRootVersion.equals(this.jakartaPagesVersionDouble.toString())) {
                this.err.jspError((Node)root, "jsp.error.tagfile.jspVersionMismatch", jspRootVersion, this.jakartaPagesVersionDouble.toString());
            }
            this.visitBody(root);
        }

        @Override
        public void visit(Node.TagDirective tagDirective) throws WaspException {
            JspUtil.checkAttributes("Tag directive", tagDirective, tagDirectiveAttrs, this.err);
            this.bodycontent = this.checkConflict(tagDirective, this.bodycontent, "body-content");
            if (!(this.bodycontent == null || this.bodycontent.equals("empty") || this.bodycontent.equals("tagdependent") || this.bodycontent.equals("scriptless"))) {
                this.err.jspError((Node)tagDirective, "jsp.error.tagdirective.badbodycontent", this.bodycontent);
            }
            this.dynamicAttrsMapName = this.checkConflict(tagDirective, this.dynamicAttrsMapName, "dynamic-attributes");
            if (this.dynamicAttrsMapName != null) {
                this.checkUniqueName(this.dynamicAttrsMapName, Name.TAG_DYNAMIC, tagDirective);
            }
            this.smallIcon = this.checkConflict(tagDirective, this.smallIcon, "small-icon");
            this.largeIcon = this.checkConflict(tagDirective, this.largeIcon, "large-icon");
            this.description = this.checkConflict(tagDirective, this.description, "description");
            this.displayName = this.checkConflict(tagDirective, this.displayName, "display-name");
            this.example = this.checkConflict(tagDirective, this.example, "example");
            if (tagDirective.getAttributeValue("deferredSyntaxAllowedAsLiteral") != null && Double.compare(this.jakartaPagesVersionDouble, Constants.JSP_VERSION_2_1) < 0) {
                this.err.jspError("jsp.error.invalidTagDirectiveAttrUnless21", "deferredSyntaxAllowedAsLiteral");
            }
        }

        private String checkConflict(Node node, String oldAttrValue, String attr) throws WaspException {
            String result = oldAttrValue;
            String attrValue = node.getAttributeValue(attr);
            if (attrValue != null) {
                if (oldAttrValue != null && !oldAttrValue.equals(attrValue)) {
                    this.err.jspError(node, "jsp.error.tag.conflict.attr", attr, oldAttrValue, attrValue);
                }
                result = attrValue;
            }
            return result;
        }

        @Override
        public void visit(Node.AttributeDirective attributeDirective) throws WaspException {
            JspUtil.checkAttributes("Attribute directive", attributeDirective, attributeDirectiveAttrs, this.err);
            String attrName = attributeDirective.getAttributeValue("name");
            boolean required = JspUtil.booleanValue(attributeDirective.getAttributeValue("required"));
            boolean rtexprvalue = true;
            String rtexprvalueString = attributeDirective.getAttributeValue("rtexprvalue");
            if (rtexprvalueString != null) {
                rtexprvalue = JspUtil.booleanValue(rtexprvalueString);
            }
            boolean fragment = JspUtil.booleanValue(attributeDirective.getAttributeValue("fragment"));
            String type = attributeDirective.getAttributeValue("type");
            String deferredValue = attributeDirective.getAttributeValue("deferredValue");
            String deferredMethod = attributeDirective.getAttributeValue("deferredMethod");
            String expectedType = attributeDirective.getAttributeValue("deferredValueType");
            String methodSignature = attributeDirective.getAttributeValue("deferredMethodSignature");
            if (Double.compare(this.jakartaPagesVersionDouble, Constants.JSP_VERSION_2_1) < 0) {
                if (deferredValue != null) {
                    this.err.jspError("jsp.error.invalidAttrDirectiveAttrUnless21", "deferredValue");
                }
                if (deferredMethod != null) {
                    this.err.jspError("jsp.error.invalidAttrDirectiveAttrUnless21", "deferredMethod");
                }
                if (expectedType != null) {
                    this.err.jspError("jsp.error.invalidAttrDirectiveAttrUnless21", "deferredValueType");
                }
                if (methodSignature != null) {
                    this.err.jspError("jsp.error.invalidAttrDirectiveAttrUnless21", "deferredMethodSignature");
                }
            }
            boolean isDeferredValue = JspUtil.booleanValue(deferredValue);
            boolean isDeferredMethod = JspUtil.booleanValue(deferredMethod);
            if (expectedType == null) {
                if (isDeferredValue) {
                    expectedType = "java.lang.Object";
                }
            } else {
                if (deferredValue != null && !isDeferredValue) {
                    this.err.jspError("jsp.error.deferredvaluewithtype");
                }
                isDeferredValue = true;
            }
            if (methodSignature == null) {
                if (isDeferredMethod) {
                    methodSignature = "void method()";
                }
            } else {
                if (deferredMethod != null && !isDeferredMethod) {
                    this.err.jspError("jsp.error.deferredmethodwithsignature");
                }
                isDeferredMethod = true;
            }
            if (fragment) {
                if (type != null) {
                    this.err.jspError(attributeDirective, "jsp.error.fragmentwithtype");
                }
                rtexprvalue = true;
                if (rtexprvalueString != null) {
                    this.err.jspError(attributeDirective, "jsp.error.frgmentwithrtexprvalue");
                }
            } else if (type == null) {
                type = isDeferredValue ? "jakarta.el.ValueExpression" : (isDeferredMethod ? "jakarta.el.MethodExpression" : "java.lang.String");
            } else if (isDeferredValue || isDeferredMethod) {
                this.err.jspError("jsp.error.deferredwithtype");
            }
            if (isDeferredValue || isDeferredMethod) {
                rtexprvalue = false;
            }
            TagAttributeInfo tagAttributeInfo = new TagAttributeInfo(attrName, required, type, rtexprvalue, fragment, this.description, isDeferredValue, isDeferredMethod, expectedType, methodSignature);
            this.tagAttributes.add(tagAttributeInfo);
            this.checkUniqueName(attrName, Name.ATTR_NAME, attributeDirective, tagAttributeInfo);
        }

        @Override
        public void visit(Node.VariableDirective variableDirective) throws WaspException {
            String className;
            JspUtil.checkAttributes("Variable directive", variableDirective, variableDirectiveAttrs, this.err);
            String nameGiven = variableDirective.getAttributeValue("name-given");
            String nameFromAttribute = variableDirective.getAttributeValue("name-from-attribute");
            if (nameGiven == null && nameFromAttribute == null) {
                this.err.jspError("jsp.error.variable.either.name");
            }
            if (nameGiven != null && nameFromAttribute != null) {
                this.err.jspError("jsp.error.variable.both.name");
            }
            String alias = variableDirective.getAttributeValue("alias");
            if (nameFromAttribute != null && alias == null || nameFromAttribute == null && alias != null) {
                this.err.jspError("jsp.error.variable.alias");
            }
            if ((className = variableDirective.getAttributeValue("variable-class")) == null) {
                className = "java.lang.String";
            }
            String declareStr = variableDirective.getAttributeValue("declare");
            boolean declare = true;
            if (declareStr != null) {
                declare = JspUtil.booleanValue(declareStr);
            }
            int scope = 0;
            String scopeStr = variableDirective.getAttributeValue("scope");
            if (scopeStr != null && !"NESTED".equals(scopeStr)) {
                if ("AT_BEGIN".equals(scopeStr)) {
                    scope = 1;
                } else if ("AT_END".equals(scopeStr)) {
                    scope = 2;
                }
            }
            if (nameFromAttribute != null) {
                nameGiven = alias;
                this.checkUniqueName(nameFromAttribute, Name.VAR_NAME_FROM, variableDirective);
                this.checkUniqueName(alias, Name.VAR_ALIAS, variableDirective);
            } else {
                this.checkUniqueName(nameGiven, Name.VAR_NAME_GIVEN, variableDirective);
            }
            this.tagVariables.add(new TagVariableInfo(nameGiven, nameFromAttribute, className, declare, scope));
        }

        public TagInfo getTagInfo() throws WaspException {
            if (this.name == null) {
                // empty if block
            }
            if (this.bodycontent == null) {
                this.bodycontent = "scriptless";
            }
            String tagClassName = JspUtil.getTagHandlerClassName(this.path, this.err);
            TagVariableInfo[] tagVariableInfos = this.tagVariables.toArray(new TagVariableInfo[0]);
            TagAttributeInfo[] tagAttributeInfo = this.tagAttributes.toArray(new TagAttributeInfo[0]);
            return new WaspTagInfo(this.name, tagClassName, this.bodycontent, this.description, this.tagLibInfo, this.tei, tagAttributeInfo, this.displayName, this.smallIcon, this.largeIcon, tagVariableInfos, this.dynamicAttrsMapName);
        }

        private void checkUniqueName(String name, Name type, Node node) throws WaspException {
            this.checkUniqueName(name, type, node, null);
        }

        private void checkUniqueName(String name, Name type, Node node, TagAttributeInfo attr) throws WaspException {
            HashMap<String, NameEntry> table = type == Name.VAR_NAME_FROM ? this.nameFromTable : this.nameTable;
            NameEntry nameEntry = table.get(name);
            if (nameEntry != null) {
                if (type != Name.TAG_DYNAMIC || nameEntry.getType() != Name.TAG_DYNAMIC) {
                    int line = nameEntry.getNode().getStart().getLineNumber();
                    this.err.jspError(node, "jsp.error.tagfile.nameNotUnique", type.getAttribute(), type.getDirective(), nameEntry.getType().getAttribute(), nameEntry.getType().getDirective(), Integer.toString(line));
                }
            } else {
                table.put(name, new NameEntry(type, node, attr));
            }
        }

        void postCheck() throws WaspException {
            for (String nameFrom : this.nameFromTable.keySet()) {
                NameEntry nameEntry = this.nameTable.get(nameFrom);
                NameEntry nameFromEntry = this.nameFromTable.get(nameFrom);
                Node nameFromNode = nameFromEntry.getNode();
                if (nameEntry == null) {
                    this.err.jspError(nameFromNode, "jsp.error.tagfile.nameFrom.noAttribute", nameFrom);
                    continue;
                }
                Node node = nameEntry.getNode();
                TagAttributeInfo tagAttr = nameEntry.getTagAttributeInfo();
                if ("java.lang.String".equals(tagAttr.getTypeName()) && tagAttr.isRequired() && !tagAttr.canBeRequestTime()) continue;
                this.err.jspError(nameFromNode, "jsp.error.tagfile.nameFrom.badAttribute", nameFrom, Integer.toString(node.getStart().getLineNumber()));
            }
        }

        static class NameEntry {
            private Name type;
            private Node node;
            private TagAttributeInfo attr;

            NameEntry(Name type, Node node, TagAttributeInfo attr) {
                this.type = type;
                this.node = node;
                this.attr = attr;
            }

            Name getType() {
                return this.type;
            }

            Node getNode() {
                return this.node;
            }

            TagAttributeInfo getTagAttributeInfo() {
                return this.attr;
            }
        }

        private static enum Name {
            ATTR_NAME("name", "attribute"),
            VAR_NAME_GIVEN("name-given", "variable"),
            VAR_NAME_FROM("name-from-attribute", "variable"),
            VAR_ALIAS("alias", "variable"),
            TAG_DYNAMIC("dynamic-attributes", "tag");

            private String attribute;
            private String directive;

            String getAttribute() {
                return this.attribute;
            }

            String getDirective() {
                return this.directive;
            }

            private Name(String attribute, String directive) {
                this.attribute = attribute;
                this.directive = directive;
            }
        }
    }
}

