/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.tf.timer.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.pfl.tf.timer.impl.TimerFactoryImpl;
import org.glassfish.pfl.tf.timer.spi.ObjectRegistrationManager;
import org.glassfish.pfl.tf.timer.spi.TimerFactory;

public class TimerFactoryBuilder {
    private static Map<String, TimerFactory> fmap = new HashMap<String, TimerFactory>();

    public static String getTimerName(String cname, String name) {
        return cname + "__" + name;
    }

    public static synchronized TimerFactory make(String name, String description) {
        return TimerFactoryBuilder.make(ObjectRegistrationManager.nullImpl, name, description);
    }

    public static synchronized TimerFactory make(ObjectRegistrationManager orm, String name, String description) {
        if (fmap.get(name) != null) {
            throw new IllegalArgumentException("There is currently a TimerFactory named " + name);
        }
        TimerFactoryImpl result = new TimerFactoryImpl(orm, name, description);
        fmap.put(name, result);
        return result;
    }

    public static synchronized void destroy(TimerFactory factory) {
        fmap.remove(factory.name());
    }

    public static synchronized List<TimerFactory> contents() {
        Collection<TimerFactory> coll = fmap.values();
        ArrayList<TimerFactory> list = new ArrayList<TimerFactory>(coll);
        return list;
    }
}

