/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.conversation;

import jakarta.enterprise.context.Conversation;
import jakarta.enterprise.context.ConversationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;

@ConversationScoped
@Named
public class Cumulus
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int timeout = 15000;
    private static final String customCid = "humilis";
    private static final String customCidAlreadyInUse = "alreadyInUse";
    @Inject
    private Conversation conversation;

    public void beginConversation() {
        this.conversation.begin();
    }

    public void beginConversationIdentifiedByCustomIdentifier() {
        this.conversation.begin(customCid);
    }

    public void beginNextConversationIdentifiedByCustomIdentifier() {
        this.conversation.begin(customCidAlreadyInUse);
    }

    public String beginConversationIdentifiedByCustomIdentifierAndSwallowException() {
        try {
            this.beginNextConversationIdentifiedByCustomIdentifier();
            return "error";
        }
        catch (IllegalArgumentException e) {
            return "home";
        }
    }

    public String beginConversationAndSwallowException() {
        try {
            this.conversation.begin();
            return "error";
        }
        catch (IllegalStateException e) {
            return "home";
        }
    }

    public void beginConversationAndSetTimeout() {
        this.conversation.begin();
        this.conversation.setTimeout(15000L);
    }

    public void endConversation() {
        this.conversation.end();
    }

    public String endConversationAndSwallowException() {
        try {
            this.conversation.end();
            return "error";
        }
        catch (IllegalStateException e) {
            return "home";
        }
    }

    public boolean isConversationIdentifiedByCustomIdentifier() {
        return !this.conversation.isTransient() && this.conversation.getId().equals(customCid);
    }

    public boolean isConversationIdentifierNull() {
        return this.conversation.getId() == null;
    }

    public boolean isConversationTimeoutSetProperly() {
        return this.conversation.getTimeout() == 15000L;
    }

    public boolean isConversationHasDefaultTimeout() {
        return this.conversation.getTimeout() > 0L;
    }
}

