/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrs.platform.environment.servlet;

import com.sun.ts.tests.jaxrs.common.JAXRSCommonClient;
import com.sun.ts.tests.jaxrs.platform.environment.servlet.ConsumingFilter;
import com.sun.ts.tests.jaxrs.platform.environment.servlet.Resource;
import com.sun.ts.tests.jaxrs.platform.environment.servlet.TSAppConfig;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jaxrs"), @Tag(value="platform"), @Tag(value="web")})
public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = 1L;

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_platform_environment_servlet_web/resource");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("com/sun/ts/tests/jaxrs/platform/environment/servlet/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_platform_environment_servlet_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, ConsumingFilter.class, Resource.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @Test
    public void checkServletExtensionTest() throws Exception {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "context"));
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, "is null");
        this.invoke();
    }

    @Test
    public void streamReaderRequestEntityTest() throws Exception {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "streamreader"));
        this.setProperty(JAXRSCommonClient.Property.CONTENT, Resource.class.getName());
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, Resource.class.getName());
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, "empty");
        this.invoke();
    }

    @Test
    public void prematureHttpServletResponseTest() throws Exception {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "premature"));
        this.invoke();
    }

    @Test
    public void servletFilterRequestConsumptionTest() throws Exception {
        String content = "ENTITY";
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Content-type:application/x-www-form-urlencoded");
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "entity=" + content);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "consume"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, content);
        this.invoke();
    }
}

