/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.common.client;

import com.sun.ts.tests.websocket.common.client.EndpointCallback;
import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.common.impl.StringPingMessage;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.PongMessage;
import jakarta.websocket.RemoteEndpoint;
import jakarta.websocket.Session;
import java.io.IOException;
import java.nio.ByteBuffer;

public class SendMessageCallback
extends EndpointCallback {
    protected WebSocketCommonClient.Entity entity;

    public SendMessageCallback(WebSocketCommonClient.Entity entity) {
        this.entity = entity;
    }

    @Override
    public void onOpen(Session session, EndpointConfig config) {
        super.onOpen(session, config);
        WebSocketCommonClient.logMsg("Sending entity", this.entity);
        RemoteEndpoint.Basic endpoint = session.getBasicRemote();
        try {
            if (this.entity.isInstance(String.class)) {
                this.sendString(endpoint, this.entity, 0);
            } else if (this.entity.isInstance(ByteBuffer.class)) {
                this.sendBytes(endpoint, this.entity, 0);
            } else if (this.entity.isInstance(PongMessage.class)) {
                this.sendPingPong(endpoint, this.entity.getEntityAt(PongMessage.class, 0));
            } else {
                this.sendObject(endpoint, this.entity.getEntityAt(Object.class, 0));
            }
        }
        catch (Exception i) {
            throw new RuntimeException(i);
        }
    }

    protected void sendString(RemoteEndpoint.Basic endpoint, WebSocketCommonClient.Entity entity, int index) throws IOException {
        String message = entity.getEntityAt(String.class, index);
        if (entity.length() - 1 > index) {
            endpoint.sendText(message, false);
            WebSocketCommonClient.logTrace("RemoteEndpoint.Basic.sendText(", message, ", false)");
            this.sendString(endpoint, entity, index + 1);
        } else if (index > 0) {
            endpoint.sendText(message, true);
            WebSocketCommonClient.logTrace("RemoteEndpoint.Basic.sendText(", message, ", true)");
        } else {
            endpoint.sendText(message);
            WebSocketCommonClient.logTrace("RemoteEndpoint.Basic.sendText(", message, ")");
        }
    }

    protected void sendBytes(RemoteEndpoint.Basic endpoint, WebSocketCommonClient.Entity entity, int index) throws IOException {
        ByteBuffer msg = entity.getEntityAt(ByteBuffer.class, index);
        String bytes = new String(msg.array());
        if (entity.length() - 1 > index) {
            endpoint.sendBinary(msg, false);
            WebSocketCommonClient.logTrace("RemoteEndpoint.Basic.sendBinary(", bytes, ", false)");
            this.sendBytes(endpoint, entity, index + 1);
        } else if (index > 0) {
            endpoint.sendBinary(msg, true);
            WebSocketCommonClient.logTrace("RemoteEndpoint.Basic.sendBinary(", bytes, ", true)");
        } else {
            endpoint.sendBinary(msg);
            WebSocketCommonClient.logTrace("RemoteEndpoint.Basic.sendBinary(", bytes, ")");
        }
    }

    protected void sendPingPong(RemoteEndpoint.Basic endpoint, PongMessage pong) throws Exception {
        ByteBuffer buffer = pong.getApplicationData();
        String msg = IOUtil.byteBufferToString(buffer);
        if (StringPingMessage.class.isInstance(pong)) {
            endpoint.sendPing(buffer);
            WebSocketCommonClient.logTrace("RemoteEndpoint.Basic.sendPing(", msg, ")");
        } else {
            endpoint.sendPong(buffer);
            WebSocketCommonClient.logTrace("RemoteEndpoint.Basic.sendPong(", msg, ")");
        }
    }

    protected void sendObject(RemoteEndpoint.Basic endpoint, Object message) throws Exception {
        String entity = null;
        entity = message.getClass().getName().equals("[B") ? new String((byte[])message) : message.toString();
        WebSocketCommonClient.logTrace("RemoteEndpoint.Basic.sendObject(", entity, ")");
        endpoint.sendObject(message);
    }
}

