/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered;

import org.eclipse.elk.alg.layered.ElkLayered;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.transform.ElkGraphTransformer;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.options.HierarchyHandling;
import org.eclipse.elk.core.testing.IWhiteBoxTestable;
import org.eclipse.elk.core.testing.TestController;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.ElkNode;

public final class LayeredLayoutProvider
extends AbstractLayoutProvider
implements IWhiteBoxTestable {
    private final ElkLayered elkLayered = new ElkLayered();

    public void layout(ElkNode elkgraph, IElkProgressMonitor progressMonitor) {
        ElkGraphTransformer graphTransformer = new ElkGraphTransformer();
        LGraph layeredGraph = graphTransformer.importGraph(elkgraph);
        if (elkgraph.getProperty(LayeredOptions.HIERARCHY_HANDLING) == HierarchyHandling.INCLUDE_CHILDREN) {
            this.elkLayered.doCompoundLayout(layeredGraph, progressMonitor);
        } else {
            this.elkLayered.doLayout(layeredGraph, progressMonitor);
        }
        if (!progressMonitor.isCanceled()) {
            graphTransformer.applyLayout(layeredGraph);
        }
    }

    public ElkLayered.TestExecutionState startLayoutTest(ElkNode elkgraph) {
        ElkGraphTransformer graphImporter = new ElkGraphTransformer();
        LGraph layeredGraph = graphImporter.importGraph(elkgraph);
        return this.elkLayered.prepareLayoutTest(layeredGraph);
    }

    public ElkLayered getLayoutAlgorithm() {
        return this.elkLayered;
    }

    public void setTestController(TestController controller) {
        this.elkLayered.setTestController(controller);
    }
}

