/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.dsm;

import java.util.Arrays;
import java.util.BitSet;
import org.apache.commons.math3.linear.BlockRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.eclipse.escet.common.java.Assert;

public class MatrixHelper {
    private MatrixHelper() {
    }

    public static RealMatrix normalizeColumns(RealMatrix m) {
        return MatrixHelper.normalizeColumns(m, true);
    }

    public static RealMatrix normalizeColumns(RealMatrix m, boolean copyData) {
        RealMatrix result = copyData ? new BlockRealMatrix(m.getRowDimension(), m.getColumnDimension()) : m;
        int j = 0;
        while (j < m.getColumnDimension()) {
            double[] col = m.getColumn(j);
            MatrixHelper.normalizeArray(col);
            result.setColumn(j, col);
            ++j;
        }
        return result;
    }

    public static RealMatrix normalizeRows(RealMatrix m) {
        return MatrixHelper.normalizeRows(m, true);
    }

    public static RealMatrix normalizeRows(RealMatrix m, boolean copyData) {
        RealMatrix result = copyData ? new BlockRealMatrix(m.getRowDimension(), m.getColumnDimension()) : m;
        int i = 0;
        while (i < m.getRowDimension()) {
            double[] row = m.getRow(i);
            MatrixHelper.normalizeArray(row);
            result.setRow(i, row);
            ++i;
        }
        return result;
    }

    public static void normalizeArray(double[] sequence) {
        double sum = Arrays.stream(sequence).sum();
        if (sum > 0.0) {
            int j = 0;
            while (j < sequence.length) {
                int n = j++;
                sequence[n] = sequence[n] / sum;
            }
        }
    }

    public static double getColumnMax(RealMatrix m, int column) {
        double maximum = 0.0;
        int i = 0;
        while (i < m.getRowDimension()) {
            double v = m.getEntry(i, column);
            if (i == 0 || maximum < v) {
                maximum = v;
            }
            ++i;
        }
        return maximum;
    }

    public static void prune(RealMatrix m, double[] cutValues) {
        int numCols = m.getColumnDimension();
        int numRows = m.getRowDimension();
        int j = 0;
        while (j < numCols) {
            double[] col = m.getColumn(j);
            double sum = 0.0;
            int i = 0;
            while (i < numRows) {
                if (col[i] < cutValues[j]) {
                    col[i] = 0.0;
                } else {
                    sum += col[i];
                }
                ++i;
            }
            if (sum > 0.0) {
                i = 0;
                while (i < numRows) {
                    int n = i++;
                    col[n] = col[n] / sum;
                }
            }
            m.setColumn(j, col);
            ++j;
        }
    }

    public static void clearDiagonal(RealMatrix m) {
        if (!m.isSquare()) {
            return;
        }
        int i = 0;
        while (i < m.getColumnDimension()) {
            m.setEntry(i, i, 0.0);
            ++i;
        }
    }

    public static RealMatrix scalarPower(RealMatrix m, double d) {
        return MatrixHelper.scalarPower(m, d, true);
    }

    public static RealMatrix scalarPower(RealMatrix m, double d, boolean copyData) {
        int numCols = m.getColumnDimension();
        int numRows = m.getRowDimension();
        RealMatrix result = copyData ? new BlockRealMatrix(numRows, numCols) : m;
        int i = 0;
        while (i < numRows) {
            int j = 0;
            while (j < numCols) {
                result.setEntry(i, j, Math.pow(m.getEntry(i, j), d));
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static RealMatrix shuffleRows(int[] rowShuffle, RealMatrix m) {
        int nrows = m.getRowDimension();
        int ncols = m.getColumnDimension();
        Assert.check((nrows == rowShuffle.length ? 1 : 0) != 0);
        BlockRealMatrix result = new BlockRealMatrix(nrows, ncols);
        int i = 0;
        while (i < nrows) {
            result.setRowMatrix(i, m.getRowMatrix(rowShuffle[i]));
            ++i;
        }
        return result;
    }

    public static RealMatrix shuffleColumns(int[] columnShuffle, RealMatrix m) {
        int nrows = m.getRowDimension();
        int ncols = m.getColumnDimension();
        Assert.check((ncols == columnShuffle.length ? 1 : 0) != 0);
        BlockRealMatrix result = new BlockRealMatrix(nrows, ncols);
        int i = 0;
        while (i < ncols) {
            result.setColumnMatrix(i, m.getColumnMatrix(columnShuffle[i]));
            ++i;
        }
        return result;
    }

    public static RealMatrix ones(int nrows, int ncols) {
        BlockRealMatrix result = new BlockRealMatrix(nrows, ncols);
        int i = 0;
        while (i < nrows) {
            int j = 0;
            while (j < ncols) {
                result.setEntry(i, j, 1.0);
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static BitSet find(RealMatrix m) {
        Assert.check((m.getColumnDimension() == 1 || m.getRowDimension() == 1 ? 1 : 0) != 0);
        if (m.getColumnDimension() == 1) {
            return MatrixHelper.findR(m);
        }
        return MatrixHelper.findC(m);
    }

    private static BitSet findR(RealMatrix m) {
        Assert.check((m.getColumnDimension() == 1 ? 1 : 0) != 0);
        BitSet result = new BitSet(m.getRowDimension());
        int j = 0;
        while (j < m.getRowDimension()) {
            if (m.getEntry(j, 0) != 0.0) {
                result.set(j);
            }
            ++j;
        }
        return result;
    }

    private static BitSet findC(RealMatrix m) {
        Assert.check((m.getRowDimension() == 1 ? 1 : 0) != 0);
        BitSet result = new BitSet(m.getColumnDimension());
        int j = 0;
        while (j < m.getColumnDimension()) {
            if (m.getEntry(0, j) != 0.0) {
                result.set(j);
            }
            ++j;
        }
        return result;
    }

    public static BitSet find(RealMatrix m, double value) {
        Assert.check((m.getColumnDimension() == 1 || m.getRowDimension() == 1 ? 1 : 0) != 0);
        if (m.getColumnDimension() == 1) {
            return MatrixHelper.findR(m, value);
        }
        return MatrixHelper.findC(m, value);
    }

    private static BitSet findR(RealMatrix m, double value) {
        Assert.check((m.getColumnDimension() == 1 ? 1 : 0) != 0);
        BitSet result = new BitSet(m.getRowDimension());
        int j = 0;
        while (j < m.getRowDimension()) {
            if (m.getEntry(j, 0) == value) {
                result.set(j);
            }
            ++j;
        }
        return result;
    }

    private static BitSet findC(RealMatrix m, double value) {
        Assert.check((m.getRowDimension() == 1 ? 1 : 0) != 0);
        BitSet result = new BitSet(m.getColumnDimension());
        int j = 0;
        while (j < m.getColumnDimension()) {
            if (m.getEntry(0, j) == value) {
                result.set(j);
            }
            ++j;
        }
        return result;
    }
}

