/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor.compare;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.ISharedDocumentAdapter;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DocumentRangeNode;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.compare.structuremergeviewer.StructureCreator;
import org.eclipse.compare.structuremergeviewer.StructureRootNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.linuxtools.internal.rpm.ui.editor.SpecfileEditor;
import org.eclipse.linuxtools.internal.rpm.ui.editor.SpecfileLog;
import org.eclipse.linuxtools.internal.rpm.ui.editor.compare.Messages;
import org.eclipse.linuxtools.internal.rpm.ui.editor.scanners.SpecfilePartitionScanner;
import org.eclipse.linuxtools.rpm.ui.editor.markers.SpecfileErrorHandler;
import org.eclipse.linuxtools.rpm.ui.editor.markers.SpecfileTaskHandler;
import org.eclipse.linuxtools.rpm.ui.editor.parser.Specfile;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfilePackage;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileParser;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileSection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class SpecStructureCreator
extends StructureCreator {
    private static final String SPECFILE_ROOT_NODE = "Specfile Sections";

    public String getName() {
        return Messages.SpecStructureCreator_0;
    }

    public IStructureComparator locate(Object path, Object input) {
        return null;
    }

    public String getContents(Object node, boolean ignoreWhitespace) {
        if (node instanceof IStreamContentAccessor) {
            IStreamContentAccessor sca = (IStreamContentAccessor)node;
            try {
                return SpecStructureCreator.readString(sca);
            }
            catch (CoreException e) {
                SpecfileLog.logError(e);
            }
        }
        return null;
    }

    private void parseSpecfile(DocumentRangeNode root, IDocument doc, IFile file) {
        SpecfileParser parser = new SpecfileParser();
        if (file != null) {
            FileEditorInput fei = new FileEditorInput(file);
            try {
                SpecfileEditor.getSpecfileDocumentProvider().disconnect((Object)fei);
                SpecfileEditor.getSpecfileDocumentProvider().connect((Object)fei);
            }
            catch (CoreException e) {
                SpecfileLog.logError(e);
            }
            parser.setErrorHandler(new SpecfileErrorHandler((IEditorInput)fei, doc));
            parser.setTaskHandler(new SpecfileTaskHandler(fei, doc));
            Specfile specfile = parser.parse(doc);
            String id = specfile.getName();
            SpecNode fileNode = new SpecNode((DocumentRangeNode)root.getParentNode(), 1, id, doc, 0, doc.getLength());
            for (SpecfileSection sec : specfile.getSections()) {
                try {
                    this.addNode(root, doc, sec.getName(), doc.getLineOffset(sec.getLineNumber()), doc.getLineOffset(sec.getSectionEndLine()) - doc.getLineOffset(sec.getLineNumber()), 2);
                }
                catch (BadLocationException e) {
                    SpecfileLog.logError(e);
                }
            }
            for (SpecfilePackage sPackage : specfile.getPackages().getPackages()) {
                try {
                    SpecNode pNode = this.addNode(fileNode, doc, sPackage.getPackageName(), doc.getLineOffset(sPackage.getLineNumber()), doc.getLineOffset(sPackage.getSectionEndLine()) - doc.getLineOffset(sPackage.getLineNumber()), 3);
                    for (SpecfileSection section : sPackage.getSections()) {
                        this.addNode(pNode, doc, section.getName(), doc.getLineOffset(section.getLineNumber()), doc.getLineOffset(section.getSectionEndLine()) - doc.getLineOffset(section.getLineNumber()), 4);
                    }
                }
                catch (BadLocationException e) {
                    SpecfileLog.logError(e);
                }
            }
        }
    }

    private IProgressMonitor beginWork(IProgressMonitor monitor) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        return SubMonitor.convert((IProgressMonitor)monitor);
    }

    private SpecNode addNode(DocumentRangeNode parent, IDocument doc, String name, int start, int end, int type) {
        return new SpecNode(parent, type, name, doc, start, end);
    }

    private static String readString(InputStream is, String encoding) {
        String string;
        if (is == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        char[] part = new char[2048];
        int read = 0;
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, encoding));
        try {
            while ((read = reader.read(part)) != -1) {
                buffer.append(part, 0, read);
            }
            string = buffer.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                SpecfileLog.logError(ex);
                return null;
            }
        }
        reader.close();
        return string;
    }

    public static String readString(IStreamContentAccessor sa) throws CoreException {
        InputStream is = sa.getContents();
        if (is != null) {
            String encoding = null;
            if (sa instanceof IEncodedStreamContentAccessor) {
                IEncodedStreamContentAccessor encodedSA = (IEncodedStreamContentAccessor)sa;
                encoding = encodedSA.getCharset();
            }
            if (encoding == null) {
                encoding = ResourcesPlugin.getEncoding();
            }
            return SpecStructureCreator.readString(is, encoding);
        }
        return null;
    }

    protected IDocumentPartitioner getDocumentPartitioner() {
        return new FastPartitioner((IPartitionTokenScanner)new SpecfilePartitionScanner(), SpecfilePartitionScanner.SPEC_PARTITION_TYPES);
    }

    protected String getDocumentPartitioning() {
        return "___spec_partitioning";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStructureComparator createStructureComparator(Object input, IDocument document, ISharedDocumentAdapter adapter, IProgressMonitor monitor) {
        final boolean isEditable = input instanceof IEditableContent ? ((IEditableContent)input).isEditable() : false;
        IFile file = null;
        if (input instanceof IResourceProvider) {
            IResourceProvider resourceProvider = (IResourceProvider)input;
            IResource res = resourceProvider.getResource();
            file = (IFile)res.getAdapter(IFile.class);
        }
        StructureRootNode rootNode = new StructureRootNode(this, document, input, this, adapter){

            public boolean isEditable() {
                return isEditable;
            }
        };
        try {
            monitor = this.beginWork(monitor);
            SpecNode specfileSectionRoot = new SpecNode((DocumentRangeNode)rootNode, 0, SPECFILE_ROOT_NODE, document, 0, document.getLength());
            this.parseSpecfile(specfileSectionRoot, document, file);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
        return rootNode;
    }

    private static class SpecNode
    extends DocumentRangeNode
    implements ITypedElement {
        public SpecNode(DocumentRangeNode parent, int type, String id, IDocument doc, int start, int length) {
            super(parent, type, id, doc, start, length);
            if (parent != null) {
                parent.addChild((DocumentRangeNode)this);
            }
        }

        public String getName() {
            return this.getId();
        }

        public String getType() {
            return "spec2";
        }

        public Image getImage() {
            return CompareUI.getImage((String)this.getType());
        }
    }
}

