/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.wizards.pages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainManager;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureContext;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureViewpoint;
import org.eclipse.papyrus.infra.ui.architecture.widgets.ArchitectureContextComposite;
import org.eclipse.papyrus.uml.diagram.wizards.Activator;
import org.eclipse.papyrus.uml.diagram.wizards.messages.Messages;
import org.eclipse.papyrus.uml.diagram.wizards.utils.SettingsHelper;
import org.eclipse.papyrus.uml.diagram.wizards.wizards.CreateModelWizard;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class SelectArchitectureContextPage
extends WizardPage {
    public static final String PAGE_ID = "SelectArchitectureContextPage";
    private SettingsHelper settingsHelper;
    private final boolean allowSeveralContexts;
    private String[] selectedContexts;
    private String[] selectedViewpoints;

    public SelectArchitectureContextPage() {
        this(false);
    }

    public SelectArchitectureContextPage(boolean allowSeveralContexts) {
        super(PAGE_ID);
        this.setTitle("Select Architecture Context");
        this.setDescription("Select the architecture context(s) and viewpoints to apply to the Papyrus model");
        this.allowSeveralContexts = allowSeveralContexts;
    }

    public void setWizard(IWizard newWizard) {
        super.setWizard(newWizard);
        this.settingsHelper = new SettingsHelper(this.getDialogSettings());
        List<String> contextIds = this.asList(this.settingsHelper.getArchitectureContexts());
        if (!this.allowSeveralContexts) {
            String defaultContextId = ArchitectureDomainManager.getInstance().getDefaultArchitectureContextId();
            contextIds = defaultContextId != null ? this.asList(defaultContextId) : (!contextIds.isEmpty() ? this.asList(contextIds.get(0)) : Collections.emptyList());
        }
        ArrayList<String> viewpoints = new ArrayList<String>();
        Iterator<String> i = contextIds.iterator();
        while (i.hasNext()) {
            String contextId = i.next();
            if (this.isVisibleContext(contextId)) {
                MergedArchitectureContext context = ArchitectureDomainManager.getInstance().getArchitectureContextById(contextId);
                for (MergedArchitectureViewpoint viewpoint : context.getViewpoints()) {
                    viewpoints.add(viewpoint.getId());
                }
                continue;
            }
            i.remove();
        }
        this.selectedContexts = contextIds.toArray(new String[0]);
        this.selectedViewpoints = viewpoints.toArray(new String[0]);
    }

    private <T> List<T> asList(T ... elements) {
        ArrayList<T> list = new ArrayList<T>();
        T[] TArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            T element = TArray[n2];
            list.add(element);
            ++n2;
        }
        return list;
    }

    private boolean isVisibleContext(String contextId) {
        if (contextId != null) {
            for (MergedArchitectureContext context : ArchitectureDomainManager.getInstance().getVisibleArchitectureContexts()) {
                if (context.getId() == null) {
                    Activator.log.info(" context has a null id" + String.valueOf(context));
                }
                if (!contextId.equals(context.getId())) continue;
                return true;
            }
        } else {
            Activator.log.info(" a context has not been loaded");
        }
        return false;
    }

    public void createControl(Composite parent) {
        Composite comp = SelectArchitectureContextPage.createComposite(parent, 1, 1, 1808, 0, 0);
        ((GridData)comp.getLayoutData()).widthHint = 350;
        SelectArchitectureContextPage.createVerticalSpacer(comp, 1);
        this.setControl((Control)comp);
        ArchitectureDomainManager manager = ArchitectureDomainManager.getInstance();
        MergedArchitectureContext[] contexts = manager.getVisibleArchitectureContexts().toArray(new MergedArchitectureContext[0]);
        final ArchitectureContextComposite acc = new ArchitectureContextComposite(comp, 1, 1, 1808, 0, 0);
        acc.setAllowSeveralContexts(this.allowSeveralContexts);
        acc.setSelectedContexts(this.selectedContexts);
        acc.setSelectedViewpoints(this.selectedViewpoints);
        acc.setInput((Object)contexts);
        acc.setUpdater(new ArchitectureContextComposite.Updater(){

            public void update() {
                SelectArchitectureContextPage.this.selectedContexts = acc.getSelectedContexts();
                SelectArchitectureContextPage.this.selectedViewpoints = acc.getSelectedViewpoints();
                SelectArchitectureContextPage.this.updateButtons();
            }
        });
        this.updateButtons();
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp("org.eclipse.papyrus.uml.diagram.wizards.Category");
    }

    public String[] getSelectedContexts() {
        return this.selectedContexts;
    }

    public void performFinish() {
        this.settingsHelper.saveArchitectureContexts(this.selectedContexts);
    }

    public String[] getSelectContexts() {
        return this.selectedContexts;
    }

    public String[] getSelectViewpoints() {
        return this.selectedViewpoints;
    }

    private void updateButtons() {
        this.setPageComplete(this.selectedContexts.length != 0 && this.validatePage());
    }

    protected boolean validatePage() {
        this.setMessage(null);
        this.setErrorMessage(null);
        String[] categories = this.selectedContexts;
        if (categories == null || categories.length == 0) {
            this.setErrorMessage(Messages.SelectArchitectureContextPage_select_one_category);
            return false;
        }
        return this.validateFileExtension(categories);
    }

    protected boolean validateFileExtension(String ... contexts) {
        IStatus status = ((CreateModelWizard)this.getWizard()).architectureContextChanged(contexts);
        switch (status.getSeverity()) {
            case 2: {
                this.setMessage(status.getMessage(), 2);
                break;
            }
            case 1: {
                this.setMessage(status.getMessage(), 1);
            }
        }
        return true;
    }

    private static Composite createComposite(Composite parent, int columns, int hspan, int fill, int marginwidth, int marginheight) {
        Composite g = new Composite(parent, 0);
        GridLayout layout = new GridLayout(columns, false);
        layout.marginWidth = marginwidth;
        layout.marginHeight = marginheight;
        g.setLayout((Layout)layout);
        g.setFont(parent.getFont());
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        g.setLayoutData((Object)gd);
        return g;
    }

    private static void createVerticalSpacer(Composite parent, int numlines) {
        Label lbl = new Label(parent, 0);
        GridData gd = new GridData(768);
        Layout layout = parent.getLayout();
        if (layout instanceof GridLayout) {
            gd.horizontalSpan = ((GridLayout)parent.getLayout()).numColumns;
        }
        gd.heightHint = numlines;
        lbl.setLayoutData((Object)gd);
    }
}

