/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util.lists;

import com.sun.messaging.jmq.util.lists.FifoSet;
import com.sun.messaging.jmq.util.lists.OutOfLimitsException;
import com.sun.messaging.jmq.util.lists.Prioritized;
import com.sun.messaging.jmq.util.lists.PrioritySetEntry;
import com.sun.messaging.jmq.util.lists.SetEntry;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;

public class PriorityFifoSet<E>
extends FifoSet<E>
implements Prioritized<E> {
    SetEntry<E>[] priorities = null;
    protected int defaultPriority = 0;
    int levels = 0;

    public PriorityFifoSet() {
        this(10);
    }

    public int getLevels() {
        return this.levels;
    }

    @Override
    public void clear() {
        super.clear();
        for (int i = 0; i < this.levels; ++i) {
            this.priorities[i] = null;
        }
    }

    public PriorityFifoSet(int levels) {
        this.levels = levels;
        this.priorities = new SetEntry[levels + 1];
        this.defaultPriority = levels / 2;
    }

    @Override
    public boolean add(E o) {
        assert (this.lock == null || Thread.holdsLock(this.lock));
        return this.add(this.defaultPriority, o);
    }

    @Override
    public void addAllOrdered(Collection<E> c) {
    }

    @Override
    public void addAllToFront(Collection<E> c, int priority) {
        assert (this.lock == null || Thread.holdsLock(this.lock));
        if (this.priorities[priority] == null) {
            for (E o : c) {
                this.add(priority, o);
            }
        } else {
            SetEntry<E> startOfList = null;
            SetEntry<E> endEntry = this.priorities[priority];
            for (E o : c) {
                if (this.lookup.get(o) != null) {
                    this.remove(o);
                }
                SetEntry<E> e = this.createSetEntry(o, priority);
                this.lookup.put(o, e);
                endEntry.insertEntryBefore(e);
                if (startOfList != null) continue;
                startOfList = e;
            }
            this.priorities[priority] = startOfList;
            if (this.head == endEntry) {
                this.head = startOfList;
            }
        }
    }

    public int getDefaultPriority() {
        return this.defaultPriority;
    }

    public void setDefaultPriority(int p) {
        this.defaultPriority = p;
    }

    protected SetEntry<E> createSetEntry(E o, int p) {
        return new PrioritySetEntry<E>(o, p);
    }

    @Override
    public boolean add(int pri, E o) {
        int tpri;
        assert (this.lock == null || Thread.holdsLock(this.lock));
        if (this.parent != null) {
            if (this.end != null && pri >= ((PrioritySetEntry)this.end).getPriority()) {
                throw new IllegalArgumentException("Object added is past end of subset");
            }
            if (this.start != null && pri <= ((PrioritySetEntry)this.start).getPriority()) {
                throw new IllegalArgumentException("Object added is past begining of subset");
            }
            return ((PriorityFifoSet)this.parent).add(pri, o);
        }
        if (pri >= this.priorities.length) {
            throw new OutOfLimitsException(3, pri, this.priorities.length);
        }
        if (this.lookup.get(o) != null) {
            this.remove(o);
        }
        SetEntry<E> e = this.createSetEntry(o, pri);
        this.lookup.put(o, e);
        if (this.head == null) {
            this.priorities[pri] = e;
            this.head = this.tail = e;
            return true;
        }
        int hpri = ((PrioritySetEntry)this.head).getPriority();
        if (hpri > pri) {
            this.priorities[pri] = e;
            this.head.insertEntryBefore(e);
            this.head = e;
            return true;
        }
        if (this.tail == null) {
            SetEntry fix = this.head;
            while (fix.getNext() != null) {
                fix = fix.getNext();
            }
            this.tail = fix;
        }
        if ((tpri = ((PrioritySetEntry)this.tail).getPriority()) <= pri) {
            this.tail.insertEntryAfter(e);
            if (this.priorities[pri] == null) {
                this.priorities[pri] = e;
            }
            this.tail = e;
            return true;
        }
        SetEntry<E> target = null;
        for (int i = pri + 1; i < this.priorities.length; ++i) {
            if (this.priorities[i] == null) continue;
            target = this.priorities[i];
            break;
        }
        if (target != null) {
            target.insertEntryBefore(e);
            if (this.priorities[pri] == null) {
                this.priorities[pri] = e;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toDebugString() {
        StringBuilder str = new StringBuilder();
        str.append("PriorityFifoSet[").append(this.hashCode()).append("]\n\tpriorities:\n");
        for (int i = 0; i < this.priorities.length; ++i) {
            str.append("\t\t").append(i).append('\t').append(this.priorities[i]).append('\n');
        }
        str.append("\thead=").append(this.head).append('\n');
        str.append("\ttail=").append(this.tail).append('\n');
        str.append("\tstart=").append(this.start).append('\n');
        str.append("\tend=").append(this.end).append('\n');
        Map map = this.lookup;
        synchronized (map) {
            str.append("\tlookup: size=").append(this.lookup.size()).append(", isEmpty=").append(this.lookup.isEmpty()).append('\n');
            for (Object key : this.lookup.keySet()) {
                str.append("\t\t[").append(key).append(',').append(this.lookup.get(key)).append("]\n");
            }
        }
        return str.toString();
    }

    @Override
    protected boolean cleanupEntry(SetEntry<E> e) {
        assert (this.lock == null || Thread.holdsLock(this.lock));
        PrioritySetEntry pe = (PrioritySetEntry)e;
        int pri = pe.getPriority();
        if (this.priorities[pri] == pe) {
            PrioritySetEntry nexte = (PrioritySetEntry)pe.getNext();
            this.priorities[pri] = nexte != null && nexte.getPriority() == pri ? nexte : null;
        }
        assert (pe.getPrevious() != null || pe == this.head) : pe;
        assert (pe.getNext() != null || pe == this.tail) : pe;
        return super.cleanupEntry(e);
    }

    @Override
    public boolean remove(Object o) {
        assert (this.lock == null || Thread.holdsLock(this.lock)) : String.valueOf(this.lock) + ":" + String.valueOf(this);
        return super.remove(o);
    }

    @Override
    public void sort(Comparator<SetEntry<E>> c) {
        super.sort(c);
        for (int i = 0; i < this.levels; ++i) {
            if (this.priorities[i] == null) continue;
            this.priorities[i] = this.priorities[i].sort(c);
        }
    }
}

