/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq.grizzly;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.imq.grizzly.GrizzlyIPService;
import com.sun.messaging.jmq.jmsserver.service.imq.grizzly.GrizzlyMQIPConnection;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;

public class GrizzlyMQConnectionFilter
extends BaseFilter {
    private static boolean DEBUG = false;
    protected static final String GRIZZLY_MQIPCONNECTION_ATTR = String.valueOf(GrizzlyMQConnectionFilter.class) + "connAttr";
    private final Attribute<GrizzlyMQIPConnection> connAttr = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(GRIZZLY_MQIPCONNECTION_ATTR);
    private static final BrokerResources br = Globals.getBrokerResources();
    private GrizzlyIPService service = null;

    public GrizzlyMQConnectionFilter(GrizzlyIPService s) {
        this.service = s;
    }

    public NextAction handleAccept(FilterChainContext ctx) throws IOException {
        Connection c = ctx.getConnection();
        try {
            GrizzlyMQIPConnection conn = this.service.createConnection(c);
            this.connAttr.set((AttributeStorage)c, (Object)conn);
            Globals.getConnectionManager().addConnection(conn);
            if (DEBUG) {
                Globals.getLogger().log(8, "GrizzlyMQConnectionFilter.handleAccept(): " + String.valueOf(conn) + "[" + String.valueOf(c) + "]");
            }
        }
        catch (Exception e) {
            Logger logger = Globals.getLogger();
            Globals.getLogger();
            logger.logStack(32, e.getMessage(), e);
            throw new IOException(e.getMessage(), e);
        }
        return ctx.getInvokeAction();
    }

    public NextAction handleClose(FilterChainContext ctx) throws IOException {
        block4: {
            Connection c = ctx.getConnection();
            GrizzlyMQIPConnection conn = (GrizzlyMQIPConnection)this.connAttr.get((AttributeStorage)c);
            if (DEBUG) {
                Globals.getLogger().log(8, "GrizzlyMQConnectionFilter.handleClose(): " + String.valueOf(conn) + "[" + String.valueOf(c) + "]");
            }
            if (conn != null && conn.getConnectionState() < 6) {
                try {
                    conn.destroyConnection(true, 5, br.getKString("B0061"));
                }
                catch (Exception e) {
                    if (!DEBUG) break block4;
                    Globals.getLogger().log(16, e.getMessage(), e);
                }
            }
        }
        return super.handleClose(ctx);
    }
}

