/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lucene.impl.config;

import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.config.SailConfigException;
import org.eclipse.rdf4j.sail.config.SailFactory;
import org.eclipse.rdf4j.sail.config.SailImplConfig;
import org.eclipse.rdf4j.sail.lucene.LuceneSail;
import org.eclipse.rdf4j.sail.lucene.config.AbstractLuceneSailConfig;
import org.eclipse.rdf4j.sail.lucene.impl.LuceneIndex;
import org.eclipse.rdf4j.sail.lucene.impl.config.LuceneSailConfig;

public class LuceneSailFactory
implements SailFactory {
    public static final String SAIL_TYPE = "openrdf:LuceneSail";

    public String getSailType() {
        return SAIL_TYPE;
    }

    public SailImplConfig getConfig() {
        return new LuceneSailConfig();
    }

    public Sail getSail(SailImplConfig config) throws SailConfigException {
        if (!SAIL_TYPE.equals(config.getType())) {
            throw new SailConfigException("Invalid Sail type: " + config.getType());
        }
        LuceneSail luceneSail = new LuceneSail();
        luceneSail.setParameter("index", LuceneIndex.class.getName());
        if (config instanceof AbstractLuceneSailConfig) {
            AbstractLuceneSailConfig luceneConfig = (AbstractLuceneSailConfig)config;
            luceneSail.setParameter("lucenedir", luceneConfig.getIndexDir());
            for (String key : luceneConfig.getParameterNames()) {
                luceneSail.setParameter(key, luceneConfig.getParameter(key));
            }
        }
        return luceneSail;
    }
}

