/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl;

import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.ast.Shape;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.SingleCloseablePlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.results.lazy.ValidationResultIterator;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;
import org.slf4j.Logger;

class ShapeValidationContainer {
    private final Shape shape;
    private final boolean logValidationViolations;
    private final PlanNode planNode;
    private final ValidationExecutionLogger validationExecutionLogger;
    private final long effectiveValidationResultsLimitPerConstraint;
    private final boolean performanceLogging;
    private final Logger logger;
    private volatile CloseableIteration<? extends ValidationTuple> iterator;

    public ShapeValidationContainer(Shape shape, Supplier<PlanNode> planNodeSupplier, boolean logValidationExecution, boolean logValidationViolations, long effectiveValidationResultsLimitPerConstraint, boolean performanceLogging, boolean logValidationPlans, Logger logger, ConnectionsGroup connectionsGroup) {
        this.shape = shape;
        this.logValidationViolations = logValidationViolations;
        this.effectiveValidationResultsLimitPerConstraint = effectiveValidationResultsLimitPerConstraint;
        this.performanceLogging = performanceLogging;
        this.logger = logger;
        try {
            PlanNode planNode = planNodeSupplier.get();
            if (logValidationPlans) {
                StringBuilder planAsGraphvizDot = new StringBuilder();
                planAsGraphvizDot.append("rank1 [style=invisible];\nrank2 [style=invisible];\n\nrank1 -> rank2 [color=white];\n");
                planAsGraphvizDot.append("{\n").append("\trank = same;\n").append("\trank2 -> ").append(System.identityHashCode(connectionsGroup.getBaseConnection())).append(" -> ").append(System.identityHashCode(connectionsGroup.getAddedStatements())).append(" -> ").append(System.identityHashCode(connectionsGroup.getRemovedStatements())).append(" [ style=invis ];\n").append("\trankdir = LR;\n").append("}\n");
                planAsGraphvizDot.append(System.identityHashCode(connectionsGroup.getBaseConnection())).append(" [label=\"").append("BaseConnection").append("\" fillcolor=\"#CACADB\", style=filled];").append("\n");
                planAsGraphvizDot.append(System.identityHashCode(connectionsGroup.getAddedStatements())).append(" [label=\"").append("AddedStatements").append("\" fillcolor=\"#CEDBCA\", style=filled];").append("\n");
                planAsGraphvizDot.append(System.identityHashCode(connectionsGroup.getRemovedStatements())).append(" [label=\"").append("RemovedStatements").append("\" fillcolor=\"#DBCFC9r\", style=filled];").append("\n");
                planNode.getPlanAsGraphvizDot(planAsGraphvizDot);
                String[] split = planAsGraphvizDot.toString().split("\n");
                planAsGraphvizDot = new StringBuilder();
                Arrays.stream(split).map(s -> "\t" + s + "\n").forEach(planAsGraphvizDot::append);
                logger.info("Plan as Graphviz dot:\ndigraph G {\n{}}", (Object)planAsGraphvizDot);
            }
            this.validationExecutionLogger = ValidationExecutionLogger.getInstance(logValidationExecution);
            if (!planNode.isGuaranteedEmpty()) {
                assert (planNode instanceof SingleCloseablePlanNode);
                planNode.receiveLogger(this.validationExecutionLogger);
                this.planNode = planNode;
            } else {
                this.planNode = planNode;
            }
        }
        catch (Throwable e) {
            logger.warn("Error processing SHACL Shape {}", (Object)shape.getId(), (Object)e);
            logger.warn("Error processing SHACL Shape\n{}", (Object)shape, (Object)e);
            if (e instanceof Error) {
                throw e;
            }
            throw new SailException("Error processing SHACL Shape " + shape.getId() + "\n" + shape, e);
        }
    }

    public Shape getShape() {
        return this.shape;
    }

    public boolean hasPlanNode() {
        return !this.planNode.isGuaranteedEmpty();
    }

    /*
     * Exception decompiling
     */
    public ValidationResultIterator performValidation() throws SailException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private long getTimeStamp() {
        if (this.performanceLogging) {
            return System.currentTimeMillis();
        }
        return 0L;
    }

    private void handlePreLogging() {
        if (this.validationExecutionLogger.isEnabled()) {
            this.logger.info("Start execution of plan:\n{}\n", (Object)this.getShape().toString());
        }
    }

    private void handlePostLogging(long before, ValidationResultIterator validationResults) {
        if (this.validationExecutionLogger.isEnabled()) {
            this.validationExecutionLogger.flush();
        }
        if (validationResults != null) {
            if (this.performanceLogging) {
                long after = System.currentTimeMillis();
                this.logger.info("Execution of plan took {} ms for:\n{}\n", (Object)(after - before), (Object)this.getShape().toString());
            }
            if (this.validationExecutionLogger.isEnabled()) {
                this.logger.info("Finished execution of plan:\n{}\n", (Object)this.getShape().toString());
            }
            if (this.logValidationViolations && !validationResults.conforms()) {
                List<ValidationTuple> tuples = validationResults.getTuples();
                this.logger.info("SHACL not valid. The following experimental debug results were produced:\n\t\t{}\n\n{}\n", (Object)tuples.stream().map(ValidationTuple::toString).collect(Collectors.joining("\n\t\t")), (Object)this.getShape().toString());
            }
        }
    }

    public void forceClose() {
        CloseableIteration<? extends ValidationTuple> iterator = this.iterator;
        if (iterator != null) {
            try {
                iterator.close();
            }
            finally {
                this.iterator = null;
            }
        }
    }
}

