/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lmdb;

import java.nio.ByteBuffer;

public final class Varint {
    private Varint() {
    }

    public static void writeUnsigned(ByteBuffer bb, long value) {
        if (value <= 240L) {
            bb.put((byte)value);
        } else if (value <= 2287L) {
            bb.put((byte)((value - 240L) / 256L + 241L));
            bb.put((byte)((value - 240L) % 256L));
        } else if (value <= 67823L) {
            bb.put((byte)-7);
            bb.put((byte)((value - 2288L) / 256L));
            bb.put((byte)((value - 2288L) % 256L));
        } else {
            int bytes = Varint.descriptor(value) + 1;
            bb.put((byte)(250 + (bytes - 3)));
            Varint.writeSignificantBits(bb, value, bytes);
        }
    }

    public static int calcLengthUnsigned(long value) {
        if (value <= 240L) {
            return 1;
        }
        if (value <= 2287L) {
            return 2;
        }
        if (value <= 67823L) {
            return 3;
        }
        int bytes = Varint.descriptor(value) + 1;
        return 1 + bytes;
    }

    public static int calcListLengthUnsigned(long a, long b, long c, long d) {
        return Varint.calcLengthUnsigned(a) + Varint.calcLengthUnsigned(b) + Varint.calcLengthUnsigned(c) + Varint.calcLengthUnsigned(d);
    }

    private static byte descriptor(long value) {
        return value == 0L ? (byte)0 : (byte)(7 - Long.numberOfLeadingZeros(value) / 8);
    }

    public static long readUnsigned(ByteBuffer bb) throws IllegalArgumentException {
        int a0 = bb.get() & 0xFF;
        if (a0 <= 240) {
            return a0;
        }
        if (a0 <= 248) {
            int a1 = bb.get() & 0xFF;
            return 240 + 256 * (a0 - 241) + a1;
        }
        if (a0 == 249) {
            int a1 = bb.get() & 0xFF;
            int a2 = bb.get() & 0xFF;
            return 2288 + 256 * a1 + a2;
        }
        int bytes = a0 - 250 + 3;
        return Varint.readSignificantBits(bb, bytes);
    }

    public static long readUnsigned(ByteBuffer bb, int pos) throws IllegalArgumentException {
        int a0 = bb.get(pos) & 0xFF;
        if (a0 <= 240) {
            return a0;
        }
        if (a0 <= 248) {
            int a1 = bb.get(pos + 1) & 0xFF;
            return 240 + 256 * (a0 - 241) + a1;
        }
        if (a0 == 249) {
            int a1 = bb.get(pos + 1) & 0xFF;
            int a2 = bb.get(pos + 1) & 0xFF;
            return 2288 + 256 * a1 + a2;
        }
        int bytes = a0 - 250 + 3;
        return Varint.readSignificantBits(bb, pos + 1, bytes);
    }

    public static int firstToLength(byte a0) {
        int a0Unsigned = a0 & 0xFF;
        if (a0Unsigned <= 240) {
            return 1;
        }
        if (a0Unsigned <= 248) {
            return 2;
        }
        if (a0Unsigned == 249) {
            return 3;
        }
        int bytes = a0Unsigned - 250 + 3;
        return 1 + bytes;
    }

    public static long readListElementUnsigned(ByteBuffer bb, int index) {
        int pos = 0;
        for (int i = 0; i < index; ++i) {
            pos += Varint.firstToLength(bb.get(pos));
        }
        return Varint.readUnsigned(bb, pos);
    }

    public static void writeListUnsigned(ByteBuffer bb, long[] values) {
        for (int i = 0; i < values.length; ++i) {
            long value = values[i];
            if (value <= 240L) {
                bb.put((byte)value);
                continue;
            }
            if (value <= 2287L) {
                bb.put((byte)((value - 240L) / 256L + 241L));
                bb.put((byte)((value - 240L) % 256L));
                continue;
            }
            if (value <= 67823L) {
                bb.put((byte)-7);
                bb.put((byte)((value - 2288L) / 256L));
                bb.put((byte)((value - 2288L) % 256L));
                continue;
            }
            int bytes = Varint.descriptor(value) + 1;
            bb.put((byte)(250 + (bytes - 3)));
            Varint.writeSignificantBits(bb, value, bytes);
        }
    }

    public static void readListUnsigned(ByteBuffer bb, long[] values) {
        for (int i = 0; i < values.length; ++i) {
            values[i] = Varint.readUnsigned(bb);
        }
    }

    public static void readListUnsigned(ByteBuffer bb, int[] indexMap, long[] values) {
        for (int i = 0; i < values.length; ++i) {
            values[indexMap[i]] = Varint.readUnsigned(bb);
        }
    }

    private static void writeSignificantBits(ByteBuffer bb, long value, int bytes) {
        while (bytes-- > 0) {
            bb.put((byte)(0xFFL & value >>> bytes * 8));
        }
    }

    private static long readSignificantBits(ByteBuffer bb, int bytes) {
        long value = (long)(bb.get() & 0xFF) << --bytes * 8;
        while (bytes-- > 0) {
            value |= (long)(bb.get() & 0xFF) << bytes * 8;
        }
        return value;
    }

    private static long readSignificantBits(ByteBuffer bb, int pos, int bytes) {
        long value = (long)(bb.get(pos++) & 0xFF) << --bytes * 8;
        while (bytes-- > 0) {
            value |= (long)(bb.get(pos++) & 0xFF) << bytes * 8;
        }
        return value;
    }

    private static int compareRegion(ByteBuffer bb1, int startIdx1, ByteBuffer bb2, int startIdx2, int length) {
        int result = 0;
        for (int i = 0; result == 0 && i < length; ++i) {
            result = (bb1.get(startIdx1 + i) & 0xFF) - (bb2.get(startIdx2 + i) & 0xFF);
        }
        return result;
    }

    public static class GroupMatcher {
        final ByteBuffer value;
        final boolean[] shouldMatch;
        final int[] lengths;

        public GroupMatcher(ByteBuffer value, boolean[] shouldMatch) {
            this.value = value;
            this.shouldMatch = shouldMatch;
            this.lengths = new int[shouldMatch.length];
            int pos = 0;
            for (int i = 0; i < this.lengths.length; ++i) {
                int length;
                this.lengths[i] = length = Varint.firstToLength(value.get(pos));
                pos += length;
            }
        }

        public GroupMatcher(ByteBuffer value, boolean a, boolean b, boolean c, boolean d, boolean e) {
            this(value, new boolean[]{a, b, c, d, e});
        }

        public boolean matches(ByteBuffer other) {
            int thisPos = 0;
            int otherPos = 0;
            for (int i = 0; i < this.shouldMatch.length; ++i) {
                int length = this.lengths[i];
                int otherLength = Varint.firstToLength(other.get(otherPos));
                if (this.shouldMatch[i] && (length != otherLength || Varint.compareRegion(this.value, thisPos, other, otherPos, length) != 0)) {
                    return false;
                }
                thisPos += length;
                otherPos += otherLength;
            }
            return true;
        }
    }
}

