/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.resultio.text.csv;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.eclipse.rdf4j.common.io.CharSink;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryResultHandlerException;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.resultio.AbstractQueryResultWriter;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultFormat;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultWriter;

public class SPARQLResultsCSVWriter
extends AbstractQueryResultWriter
implements TupleQueryResultWriter,
CharSink {
    private final Writer writer;
    private List<String> bindingNames;

    public SPARQLResultsCSVWriter(OutputStream out) {
        this(new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8), 1024));
    }

    public SPARQLResultsCSVWriter(Writer writer) {
        this.writer = writer;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void startQueryResult(List<String> bindingNames) throws TupleQueryResultHandlerException {
        super.startQueryResult(bindingNames);
        this.bindingNames = bindingNames;
        try {
            for (int i = 0; i < bindingNames.size(); ++i) {
                this.writer.write(bindingNames.get(i));
                if (i >= bindingNames.size() - 1) continue;
                this.writer.write(",");
            }
            this.writer.write("\r\n");
        }
        catch (IOException e) {
            throw new TupleQueryResultHandlerException((Throwable)e);
        }
    }

    public void endQueryResult() throws TupleQueryResultHandlerException {
        if (this.bindingNames == null) {
            throw new IllegalStateException("Could not end query result as startQueryResult was not called first.");
        }
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new TupleQueryResultHandlerException((Throwable)e);
        }
    }

    protected void handleSolutionImpl(BindingSet bindingSet) throws TupleQueryResultHandlerException {
        if (this.bindingNames == null) {
            throw new IllegalStateException("Must call startQueryResult before handleSolution");
        }
        try {
            for (int i = 0; i < this.bindingNames.size(); ++i) {
                String name = this.bindingNames.get(i);
                Value value = bindingSet.getValue(name);
                if (value != null) {
                    this.writeValue(value);
                }
                if (i >= this.bindingNames.size() - 1) continue;
                this.writer.write(",");
            }
            this.writer.write("\r\n");
        }
        catch (IOException e) {
            throw new TupleQueryResultHandlerException((Throwable)e);
        }
    }

    public final TupleQueryResultFormat getTupleQueryResultFormat() {
        return TupleQueryResultFormat.CSV;
    }

    public final TupleQueryResultFormat getQueryResultFormat() {
        return this.getTupleQueryResultFormat();
    }

    protected void writeValue(Value val) throws IOException {
        if (val instanceof Resource) {
            this.writeResource((Resource)val);
        } else {
            this.writeLiteral((Literal)val);
        }
    }

    protected void writeResource(Resource res) throws IOException {
        if (res instanceof IRI) {
            this.writeURI((IRI)res);
        } else {
            this.writeBNode((BNode)res);
        }
    }

    protected void writeURI(IRI uri) throws IOException {
        String uriString = uri.toString();
        boolean quoted = uriString.contains(",");
        if (quoted) {
            this.writer.write("\"");
        }
        this.writer.write(uriString);
        if (quoted) {
            this.writer.write("\"");
        }
    }

    protected void writeBNode(BNode bNode) throws IOException {
        this.writer.write("_:");
        this.writer.write(bNode.getID());
    }

    private void writeLiteral(Literal literal) throws IOException {
        String label = literal.getLabel();
        IRI datatype = literal.getDatatype();
        boolean quoted = false;
        if (XMLDatatypeUtil.isIntegerDatatype((IRI)datatype) || XMLDatatypeUtil.isDecimalDatatype((IRI)datatype) || XSD.DOUBLE.equals((Object)datatype)) {
            try {
                String normalized = XMLDatatypeUtil.normalize((String)label, (IRI)datatype);
                this.writer.write(normalized);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (label.contains(",") || label.contains("\r") || label.contains("\n") || label.contains("\"")) {
            quoted = true;
            label = label.replace("\"", "\"\"");
        }
        if (quoted) {
            this.writer.write("\"");
        }
        this.writer.write(label);
        if (quoted) {
            this.writer.write("\"");
        }
    }

    public void startDocument() throws QueryResultHandlerException {
    }

    public void handleStylesheet(String stylesheetUrl) throws QueryResultHandlerException {
    }

    public void startHeader() throws QueryResultHandlerException {
    }

    public void handleLinks(List<String> linkUrls) throws QueryResultHandlerException {
    }

    public void endHeader() throws QueryResultHandlerException {
    }

    public void handleBoolean(boolean value) throws QueryResultHandlerException {
        throw new UnsupportedOperationException("Cannot handle boolean results");
    }

    public void handleNamespace(String prefix, String uri) throws QueryResultHandlerException {
    }
}

