/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.serializer;

import java.io.IOException;
import java.util.Comparator;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.serializer.SerializerInteger;

public class SerializerIntegerDelta
extends SerializerInteger {
    @Override
    public void serialize(DataOutput2 out, Integer value) throws IOException {
        out.packInt(value);
    }

    @Override
    public Integer deserialize(DataInput2 in, int available) throws IOException {
        return new Integer(in.unpackInt());
    }

    @Override
    public void valueArraySerialize(DataOutput2 out, Object vals) throws IOException {
        int[] keys = (int[])vals;
        int prev = keys[0];
        out.packInt(prev);
        for (int i = 1; i < keys.length; ++i) {
            int curr = keys[i];
            out.packInt(curr - prev);
            if (curr < prev) {
                throw new AssertionError((Object)"not sorted");
            }
            prev = curr;
        }
    }

    public int[] valueArrayDeserialize(DataInput2 in, int size) throws IOException {
        int[] ret = new int[size];
        int prev = 0;
        for (int i = 0; i < size; ++i) {
            ret[i] = prev += in.unpackInt();
        }
        return ret;
    }

    @Override
    public Integer valueArrayBinaryGet(DataInput2 input, int keysLen, int pos) throws IOException {
        int a = 0;
        while (pos-- >= 0) {
            a += input.unpackInt();
        }
        return a;
    }

    @Override
    public int valueArrayBinarySearch(Integer key, DataInput2 input, int keysLen, Comparator comparator) throws IOException {
        if (comparator != this) {
            return super.valueArrayBinarySearch(key, input, keysLen, comparator);
        }
        int key2 = key;
        int from = 0;
        for (int pos = 0; pos < keysLen; ++pos) {
            if (key2 > (from += input.unpackInt())) continue;
            input.unpackLongSkip(keysLen - pos - 1);
            return key2 == from ? pos : -(pos + 1);
        }
        return -(keysLen + 1);
    }

    @Override
    public int fixedSize() {
        return -1;
    }
}

