/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui.internal.team.history;

import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.util.Support;
import org.eclipse.emf.cdo.transaction.CDOTransactionCommentator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.net4j.util.ui.widgets.AbstractDialog;
import org.eclipse.net4j.util.ui.widgets.DoubleClickButtonAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class DropConfirmationDialog
extends AbstractDialog {
    private static final String TITLE = "New Commit";
    private final CDOBranchPoint sourcePoint;
    private final CDOBranch targetBranch;
    private Operation operation;

    public DropConfirmationDialog(Shell parentShell, CDOBranchPoint sourcePoint, CDOBranch targetBranch) {
        super(parentShell);
        this.sourcePoint = sourcePoint;
        this.targetBranch = targetBranch;
    }

    public CDOBranchPoint getSourcePoint() {
        return this.sourcePoint;
    }

    public CDOBranch getTargetBranch() {
        return this.targetBranch;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    protected Point getInitialSize() {
        return new Point(450, 250);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(TITLE);
    }

    protected void createUI(Composite container) {
        this.setTitle(TITLE);
        this.setMessage("Select the content of the new commit in branch " + this.targetBranch.getPathName() + ".");
        GridLayout containerGridLayout = (GridLayout)container.getLayout();
        containerGridLayout.numColumns = 3;
        GridDataFactory grab = GridDataFactory.fillDefaults().grab(true, false);
        new Label(container, 0).setLayoutData((Object)grab.create());
        Button revertToButton = new Button(container, 16);
        revertToButton.setText(this.formatOperation(Operation.REVERT_TO));
        new OperationAdapter(revertToButton, Operation.REVERT_TO);
        new Label(container, 0).setLayoutData((Object)grab.create());
        new Label(container, 0).setLayoutData((Object)grab.create());
        Button mergeFromButton = new Button(container, 16);
        mergeFromButton.setText(this.formatOperation(Operation.MERGE_FROM));
        new OperationAdapter(mergeFromButton, Operation.MERGE_FROM);
        new Label(container, 0).setLayoutData((Object)grab.create());
        if (!Support.UI_COMPARE.isAvailable()) {
            mergeFromButton.setEnabled(false);
            this.operation = Operation.REVERT_TO;
        }
        if (this.operation == Operation.MERGE_FROM) {
            mergeFromButton.setSelection(true);
        } else {
            revertToButton.setSelection(true);
            this.operation = Operation.REVERT_TO;
        }
    }

    private String formatOperation(Operation operation) {
        StringBuilder builder = new StringBuilder();
        builder.append(operation.getLabel());
        builder.append(' ');
        CDOTransactionCommentator.appendBranchPoint((StringBuilder)builder, (CDOBranchPoint)this.sourcePoint);
        return builder.toString();
    }

    public static enum Operation {
        REVERT_TO("Revert to"),
        MERGE_FROM("Merge from");

        private String label;

        private Operation(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }

    private final class OperationAdapter
    extends DoubleClickButtonAdapter {
        private final Operation operation;

        public OperationAdapter(Button button, Operation operation) {
            super(button);
            this.operation = operation;
        }

        public void widgetSelected(SelectionEvent e) {
            DropConfirmationDialog.this.operation = this.operation;
        }

        public void widgetDoubleClicked(SelectionEvent e) {
            DropConfirmationDialog.this.close();
        }
    }
}

