/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.project.facet.ui.libprov.user.internal;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jst.common.project.facet.core.libprov.user.UserLibraryProviderInstallOperationConfig;
import org.eclipse.jst.common.project.facet.core.libprov.user.internal.DownloadableLibrariesExtensionPoint;
import org.eclipse.jst.common.project.facet.core.libprov.user.internal.DownloadableLibrary;
import org.eclipse.jst.common.project.facet.ui.internal.FacetedProjectFrameworkJavaExtUiPlugin;
import org.eclipse.jst.common.project.facet.ui.libprov.user.internal.DownloadLibraryWizardLicensePage;
import org.eclipse.jst.common.project.facet.ui.libprov.user.internal.DownloadLibraryWizardMainPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class DownloadLibraryWizard
extends Wizard {
    private List<DownloadableLibrary> libraries;
    private DownloadLibraryWizardMainPage mainPage;
    private DownloadLibraryWizardLicensePage licensePage;
    private String downloadedLibraryName;

    private DownloadLibraryWizard(List<DownloadableLibrary> libraries) {
        this.libraries = libraries;
        this.setWindowTitle(Resources.downloadLibraryWizardWindowTitle);
        this.setNeedsProgressMonitor(true);
    }

    public static String open(final UserLibraryProviderInstallOperationConfig cfg) {
        Shell shell = Display.getDefault().getActiveShell();
        final ArrayList<DownloadableLibrary> libraries = new ArrayList<DownloadableLibrary>();
        try {
            IRunnableWithProgress operation = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    List libs = DownloadableLibrariesExtensionPoint.list((UserLibraryProviderInstallOperationConfig)cfg, (IProgressMonitor)monitor);
                    if (libs == null) {
                        throw new InterruptedException();
                    }
                    libraries.addAll(libs);
                }
            };
            new ProgressMonitorDialog(shell).run(true, true, operation);
        }
        catch (InvocationTargetException e) {
            FacetedProjectFrameworkJavaExtUiPlugin.log(e);
            return null;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        DownloadLibraryWizard wizard = new DownloadLibraryWizard(libraries);
        WizardDialog dlg = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
        if (dlg.open() == 0) {
            return wizard.downloadedLibraryName;
        }
        return null;
    }

    public DownloadLibraryWizardMainPage getMainPage() {
        return this.mainPage;
    }

    public DownloadLibraryWizardLicensePage getLicensePage() {
        return this.licensePage;
    }

    public DownloadableLibrary getSelectedLibrary() {
        return this.mainPage.getSelectedLibrary();
    }

    public String getLibraryName() {
        return this.mainPage.getLibraryName();
    }

    public String getDownloadDestination() {
        return this.mainPage.getDownloadDestination();
    }

    public void addPages() {
        this.mainPage = new DownloadLibraryWizardMainPage(this, this.libraries);
        this.addPage((IWizardPage)this.mainPage);
        this.licensePage = new DownloadLibraryWizardLicensePage();
        this.addPage((IWizardPage)this.licensePage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        DownloadableLibrary library;
        if (page == this.mainPage && (library = this.getSelectedLibrary()) != null && library.getLicenseUrl() != null) {
            return this.licensePage;
        }
        return null;
    }

    public boolean performFinish() {
        final DownloadableLibrary library = this.getSelectedLibrary();
        final String localLibraryName = this.getLibraryName();
        String dest = this.getDownloadDestination();
        final File destFolder = new File(dest);
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        library.download(destFolder, localLibraryName, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    DownloadLibraryWizard.this.downloadedLibraryName = localLibraryName;
                }
            });
        }
        catch (InvocationTargetException e) {
            Throwable cause = DownloadLibraryWizard.getRootCause(e);
            MessageDialog.openError((Shell)this.getShell(), (String)Resources.transferErrorDialogTitle, (String)cause.getMessage());
        }
        catch (InterruptedException interruptedException) {}
        return true;
    }

    private static Throwable getRootCause(Throwable e) {
        Throwable cause = e.getCause();
        if (cause == null && e instanceof CoreException) {
            cause = ((CoreException)e).getStatus().getException();
        }
        if (cause != null) {
            return DownloadLibraryWizard.getRootCause(cause);
        }
        return e;
    }

    private static final class Resources
    extends NLS {
        public static String transferErrorDialogTitle;
        public static String downloadLibraryWizardWindowTitle;

        static {
            Resources.initializeMessages((String)DownloadLibraryWizard.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

