/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.widget;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.border.CSSBorder;
import org.eclipse.jst.pagedesigner.css2.provider.DimensionInfo;
import org.eclipse.jst.pagedesigner.css2.provider.ICSSWidgetProvider;
import org.eclipse.jst.pagedesigner.css2.widget.AbstractWidgetProvider;
import org.eclipse.jst.pagedesigner.editors.pagedesigner.MessageFormater;

public class InputFileWidgetProvider
extends AbstractWidgetProvider {
    private static final String BODER_QUERY_TEMPLETE = "border-{0}-style";
    private static final int GAP = 2;
    private ICSSWidgetProvider _sub1;
    private ICSSWidgetProvider _sub2;

    public InputFileWidgetProvider(ICSSStyle style, ICSSWidgetProvider sub1, ICSSWidgetProvider sub2) {
        super(style);
        this._sub1 = sub1;
        this._sub2 = sub2;
    }

    @Override
    public DimensionInfo getPreferredDimension(int width, int height) {
        Insets borderInset = new Insets();
        Insets borderPaddingInset = new Insets();
        ICSSStyle style = this.getCSSStyle();
        if (style != null) {
            borderInset = style.getBorderInsets();
            borderPaddingInset = borderInset.getAdded(style.getPaddingInsets());
        }
        Dimension d1 = this._sub1.getPreferredDimension(-1, -1).getDimension();
        Dimension d2 = this._sub2.getPreferredDimension(-1, -1).getDimension();
        int minWidth = d2.width + 2 * (borderInset.left + borderInset.right) + 2;
        int prefWidth = d1.width + d2.width + 2 * (borderPaddingInset.left + borderPaddingInset.right) + 2;
        int minHeight = borderInset.top + borderInset.bottom;
        int prefHeight = Math.max(d1.height, d2.height) + borderPaddingInset.top + borderPaddingInset.bottom;
        if (width > 0 && minWidth > width) {
            prefWidth = minWidth;
        } else if (width != 0) {
            prefWidth = width;
        }
        if (height > 0 && minHeight > height) {
            prefHeight = minHeight;
        } else if (height != 0) {
            prefHeight = height;
        }
        return new DimensionInfo(prefWidth, prefHeight, -1);
    }

    @Override
    public void paintFigure(Graphics g, Rectangle rect) {
        int prefHeight;
        Insets borderInset = new Insets();
        Insets paddingInset = new Insets();
        Insets borderPaddingInset = new Insets();
        ICSSStyle style = this.getCSSStyle();
        if (style != null) {
            borderInset = style.getBorderInsets();
            paddingInset = style.getPaddingInsets();
            borderPaddingInset.add(borderInset).add(paddingInset);
        }
        Dimension d1 = this._sub1.getPreferredDimension(-1, -1).getDimension();
        Dimension d2 = this._sub2.getPreferredDimension(-1, -1).getDimension();
        int prefWidth = d1.width + d2.width + 2 * borderPaddingInset.left + 2 * borderPaddingInset.right + 2;
        if (rect.width < prefWidth) {
            paddingInset.left = 0;
            paddingInset.right = 0;
        }
        if (rect.height < (prefHeight = Math.max(d1.height, d2.height) + borderPaddingInset.top + borderPaddingInset.bottom)) {
            paddingInset.top = 0;
            paddingInset.bottom = 0;
        }
        int width = rect.width - d2.width - (borderInset.left + borderInset.right + paddingInset.left + paddingInset.right) - 2;
        Rectangle rect1 = new Rectangle(rect.x - 1, rect.y, width, rect.height);
        Rectangle rect2 = new Rectangle(rect.x + rect1.width + 2, rect.y, rect.width - rect1.width - 3, rect.height);
        Rectangle innerRect1 = rect1.getCopy().crop(borderInset);
        Rectangle innerRect2 = rect2.getCopy().crop(borderInset);
        g.pushState();
        g.setBackgroundColor(ColorConstants.button);
        g.fillRectangle(innerRect2);
        g.popState();
        CSSBorder cssBorder = new CSSBorder(style);
        String[] edges = new String[]{"left", "right", "top", "bottom"};
        int i = 0;
        while (i < edges.length) {
            cssBorder.paintEdge(g, rect1, innerRect1, edges[i], this.getBorderStyle(edges[i]));
            ++i;
        }
        i = 0;
        while (i < edges.length) {
            String borderStyle = this.getBorderStyle(edges[i]);
            if ("inset".equals(borderStyle)) {
                borderStyle = "outset";
            }
            cssBorder.paintEdge(g, rect2, innerRect2, edges[i], borderStyle);
            ++i;
        }
        this._sub2.paintFigure(g, innerRect2.getCopy().crop(paddingInset));
    }

    private String getBorderStyle(String edge) {
        ICSSStyle style = this.getCSSStyle();
        if (style != null) {
            String property = MessageFormater.format(BODER_QUERY_TEMPLETE, edge);
            String borderStyle = style.getStyleProperty(property).toString();
            return borderStyle;
        }
        return "hidden";
    }

    @Override
    public boolean isHandlingBorder() {
        return false;
    }
}

