/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.launch;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.common.launch.EmptyDebugTarget;
import org.eclipse.m2m.internal.qvt.oml.common.launch.ProcessJob;
import org.eclipse.m2m.internal.qvt.oml.common.launch.StreamsProxy;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtInterruptedExecutionException;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.Messages;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.QvtLaunchConfigurationDelegateBase;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.QvtLaunchUtil;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtInterpretedTransformation;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.TransformationUtil;
import org.eclipse.m2m.internal.qvt.oml.runtime.util.MiscUtil;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.util.Log;
import org.eclipse.m2m.qvt.oml.util.WriterLog;
import org.eclipse.osgi.util.NLS;

public class InMemoryQvtLaunchConfigurationDelegate
extends QvtLaunchConfigurationDelegateBase {
    public static final String LAUNCH_CONFIGURATION_TYPE_ID = "org.eclipse.m2m.qvt.oml.InMemoryQvtTransformation";
    public static final IStatus statusJobDone = new Status(1, "org.eclipse.m2m.qvt.oml.runtime", 200, "", null);

    public void launch(final ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        QvtInterpretedTransformation qvtTransformation;
        String moduleUri = QvtLaunchUtil.getTransformationURI(configuration);
        try {
            qvtTransformation = new QvtInterpretedTransformation(TransformationUtil.getQvtModule(EmfUtil.makeUri((String)moduleUri)));
        }
        catch (MdaException e) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.QvtBuilderLaunchTab_TransformationNotFound, (Object)moduleUri));
        }
        final Runnable doneAction = (Runnable)configuration.getAttributes().get("org.eclipse.m2m.qvt.oml.interpreter.doneAction");
        IProgressMonitor configMonitor = (IProgressMonitor)configuration.getAttributes().get("org.eclipse.m2m.qvt.oml.interpreter.monitor");
        final IProgressMonitor actualMonitor = configMonitor != null ? configMonitor : monitor;
        final StreamsProxy streamsProxy = new StreamsProxy();
        ProcessJob processJob = new ProcessJob(Messages.InMemoryQvtLaunchConfigurationDelegate_TransformationJobName, launch, (IStreamsProxy)streamsProxy){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask(NLS.bind((String)Messages.InMemoryQvtLaunchConfigurationDelegate_RunningTaskName, (Object)TransformationUtil.getTransformationFqn(qvtTransformation)), -1);
                try {
                    try {
                        IStatus status = QvtLaunchConfigurationDelegateBase.validate(qvtTransformation, configuration);
                        if (status.getSeverity() > 2) {
                            throw new CoreException(status);
                        }
                        ExecutionContext context = QvtLaunchUtil.createContext(configuration, (Log)new WriterLog(streamsProxy.getOutputWriter()), actualMonitor);
                        QvtLaunchUtil.doLaunch(qvtTransformation, configuration, context);
                        IStatusHandler statusHandler = DebugPlugin.getDefault().getStatusHandler(statusJobDone);
                        if (statusHandler != null) {
                            Object[] handlerArgs = new Object[]{this, doneAction};
                            Object resolution = statusHandler.handleStatus(statusJobDone, (Object)handlerArgs);
                            if (!$assertionsDisabled && resolution == null) {
                                throw new AssertionError((Object)"Invalid job done status resolution");
                            }
                        }
                    }
                    catch (CoreException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        String reason = e instanceof QvtInterruptedExecutionException ? "interrupted." : "failed.";
                        throw new CoreException(MiscUtil.makeErrorStatus("Transformation '" + TransformationUtil.getTransformationFqn(qvtTransformation) + "' " + reason, e));
                    }
                }
                finally {
                    monitor.done();
                    qvtTransformation.cleanup();
                }
                return Status.OK_STATUS;
            }
        };
        launch.addProcess((IProcess)processJob);
        EmptyDebugTarget debugTarget = new EmptyDebugTarget(launch, (IProcess)processJob, "org.eclipse.m2m.qvt.oml.runtime", "QVTO");
        launch.addDebugTarget((IDebugTarget)debugTarget);
        boolean isLaunchInBackground = true;
        try {
            isLaunchInBackground = !Boolean.FALSE.toString().equals(configuration.getAttribute("org.eclipse.m2m.qvt.oml.interpreter.launchInBackground", null));
        }
        catch (Exception exception) {
            // empty catch block
        }
        processJob.setUser(!isLaunchInBackground);
        processJob.schedule();
    }

    @Override
    protected IProject[] getProjectsForProblemSearch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return new IProject[0];
    }
}

