/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.delegate.SettingBehavior;
import org.eclipse.ocl.ecore.opposites.DefaultOppositeEndFinder;
import org.eclipse.ocl.ecore.opposites.OppositeEndFinder;
import org.eclipse.ocl.examples.eventmanager.EventManager;
import org.eclipse.ocl.examples.impactanalyzer.DerivedPropertyNotifier;
import org.eclipse.ocl.examples.impactanalyzer.ImpactAnalyzer;
import org.eclipse.ocl.examples.impactanalyzer.ImpactAnalyzerFactory;
import org.eclipse.ocl.examples.impactanalyzer.PartialEvaluator;
import org.eclipse.ocl.examples.impactanalyzer.PartialEvaluatorFactory;
import org.eclipse.ocl.examples.impactanalyzer.ValueNotFoundException;
import org.eclipse.ocl.examples.impactanalyzer.configuration.ActivationOption;
import org.eclipse.ocl.examples.impactanalyzer.util.OCLFactory;

public class DerivedPropertyNotifierImpl
implements DerivedPropertyNotifier {
    private final OCLFactory oclFactory;
    private final Set<DerivedPropertyAdapter> adapters = new HashSet<DerivedPropertyAdapter>();
    private final OppositeEndFinder oppositeEndFinder;
    private final ActivationOption impactAnalyzerConfiguration;

    public DerivedPropertyNotifierImpl(ActivationOption impactAnalyzerConfiguration, OppositeEndFinder oppositeEndFinder, OCLFactory oclFactory, EPackage pkg) {
        this(impactAnalyzerConfiguration, oppositeEndFinder, oclFactory, DerivedPropertyNotifierImpl.getAllDerivedProperties(pkg));
    }

    public DerivedPropertyNotifierImpl(ActivationOption impactAnalyzerConfiguration, OppositeEndFinder oppositeEndFinder, OCLFactory oclFactory, EStructuralFeature ... derivedProperties) {
        this.oclFactory = oclFactory;
        this.oppositeEndFinder = oppositeEndFinder;
        this.impactAnalyzerConfiguration = impactAnalyzerConfiguration;
        EStructuralFeature[] eStructuralFeatureArray = derivedProperties;
        int n = derivedProperties.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature derivedProperty = eStructuralFeatureArray[n2];
            if (!derivedProperty.isDerived()) {
                throw new IllegalArgumentException("Given property must be derived");
            }
            this.adapters.add(new DerivedPropertyAdapter(derivedProperty));
            ++n2;
        }
    }

    private static EStructuralFeature[] getAllDerivedProperties(EPackage pkg) {
        ArrayList<EStructuralFeature> result = new ArrayList<EStructuralFeature>();
        for (EClassifier classifier : pkg.getEClassifiers()) {
            if (!(classifier instanceof EClass)) continue;
            EClass cls = (EClass)classifier;
            for (EStructuralFeature property : cls.getEStructuralFeatures()) {
                if (!property.isDerived()) continue;
                result.add(property);
            }
        }
        return result.toArray(new EStructuralFeature[result.size()]);
    }

    @Override
    public void subscribe(EventManager eventManager) {
        for (DerivedPropertyAdapter adapter : this.adapters) {
            adapter.subscribe(eventManager);
        }
    }

    @Override
    public void unsubscribe(EventManager eventManager) {
        for (DerivedPropertyAdapter adapter : this.adapters) {
            eventManager.unsubscribe((Adapter)adapter);
        }
    }

    private class DerivedPropertyAdapter
    implements Adapter {
        private Notifier target;
        private ImpactAnalyzer ia;
        private final EStructuralFeature property;
        private final OCLExpression derivationExp;

        public DerivedPropertyAdapter(EStructuralFeature property) {
            this.property = property;
            this.derivationExp = SettingBehavior.INSTANCE.getFeatureBody(DerivedPropertyNotifierImpl.this.oclFactory.createOCL(DerivedPropertyNotifierImpl.this.oppositeEndFinder), this.property);
        }

        public void subscribe(EventManager eventManager) {
            eventManager.subscribe(this.getImpactAnalyzer().createFilterForExpression(), (Adapter)this);
        }

        private ImpactAnalyzer getImpactAnalyzer() {
            if (this.ia == null) {
                this.ia = ImpactAnalyzerFactory.INSTANCE.createImpactAnalyzer(this.derivationExp, false, DerivedPropertyNotifierImpl.this.oppositeEndFinder, DerivedPropertyNotifierImpl.this.impactAnalyzerConfiguration, DerivedPropertyNotifierImpl.this.oclFactory);
            }
            return this.ia;
        }

        public void notifyChanged(Notification notification) {
            if (notification.isTouch()) {
                return;
            }
            Collection<EObject> impact = this.getImpactAnalyzer().getContextObjects(notification);
            if (impact.size() > 0) {
                for (EObject context : impact) {
                    int eventType;
                    Object resultPre = null;
                    Object resultPost = null;
                    try {
                        PartialEvaluator prePartEv = PartialEvaluatorFactory.INSTANCE.createPartialEvaluator(notification, (OppositeEndFinder)DefaultOppositeEndFinder.getInstance(), DerivedPropertyNotifierImpl.this.oclFactory);
                        PartialEvaluator postPartEv = PartialEvaluatorFactory.INSTANCE.createPartialEvaluator((OppositeEndFinder)DefaultOppositeEndFinder.getInstance(), DerivedPropertyNotifierImpl.this.oclFactory);
                        resultPre = prePartEv.evaluate(context, this.derivationExp);
                        resultPost = postPartEv.evaluate(context, this.derivationExp);
                    }
                    catch (ValueNotFoundException e) {
                        throw new RuntimeException("During the partial evaluation of a derived property expression, an unknown variable was found.");
                    }
                    if ((resultPre != null || resultPost == null) && resultPre.equals(resultPost)) continue;
                    Object oldValue = resultPre;
                    Object newValue = resultPost;
                    if (this.property.isMany()) {
                        if (!(resultPre instanceof List) || !(resultPost instanceof List)) {
                            throw new ClassCastException("The values of a many valued feature are not type of EList as they should.");
                        }
                        ArrayList preList = (ArrayList)resultPre;
                        ArrayList postList = (ArrayList)resultPost;
                        eventType = preList.size() == postList.size() ? 7 : (preList.size() < postList.size() ? (preList.size() + 1 == postList.size() ? 3 : 5) : (preList.size() == postList.size() + 1 ? 4 : 6));
                    } else {
                        eventType = this.property.isUnsettable() ? (resultPost == null ? 2 : 1) : 1;
                    }
                    ENotificationImpl changeNoti = new ENotificationImpl((InternalEObject)context, eventType, this.property, oldValue, newValue);
                    context.eNotify((Notification)changeNoti);
                }
            }
        }

        public Notifier getTarget() {
            return this.target;
        }

        public void setTarget(Notifier newTarget) {
            this.target = newTarget;
        }

        public boolean isAdapterForType(Object type) {
            return type == DerivedPropertyNotifierImpl.class;
        }
    }
}

