/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.sync.git.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.ptp.internal.rdt.sync.git.core.Activator;
import org.eclipse.ptp.internal.rdt.sync.git.core.CommandRunner;
import org.eclipse.ptp.internal.rdt.sync.git.core.GitSyncService;
import org.eclipse.ptp.internal.rdt.sync.git.core.JGitRepo;
import org.eclipse.ptp.internal.rdt.sync.git.core.messages.Messages;
import org.eclipse.ptp.rdt.sync.core.RecursiveSubMonitor;
import org.eclipse.ptp.rdt.sync.core.RemoteLocation;
import org.eclipse.ptp.rdt.sync.core.exceptions.MissingConnectionException;
import org.eclipse.ptp.rdt.sync.core.exceptions.RemoteExecutionException;
import org.eclipse.ptp.rdt.sync.core.exceptions.RemoteSyncException;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteFileService;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class GitRepo {
    public static final String gitArgs = "--git-dir=.ptp-sync --work-tree=.";
    private static final String instanceScopeSyncNode = "org.eclipse.ptp.rdt.sync.core";
    private static final String GIT_LOCATION_NODE_NAME = "git-location";
    private static final String commitEmail = "ptp-dev@eclipse.org";
    private static final String commitUserName = "PTP";
    private final int MAX_FILES = 100;
    private final RemoteLocation remoteLoc;
    private int remoteGitVersion;

    public GitRepo(RemoteLocation rl, IProgressMonitor monitor) throws RemoteSyncException, MissingConnectionException {
        RecursiveSubMonitor subMon = RecursiveSubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            this.remoteLoc = rl;
            try {
                subMon.subTask(Messages.GitRepo_0);
                this.remoteGitVersion = this.getRemoteGitVersion((IProgressMonitor)subMon.newChild(2));
                subMon.subTask(Messages.GitRepo_1);
                this.buildRepo((IProgressMonitor)subMon.newChild(8));
            }
            catch (IOException e) {
                throw new RemoteSyncException((Throwable)e);
            }
            catch (RemoteExecutionException e) {
                throw new RemoteSyncException((Throwable)e);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void buildRepo(IProgressMonitor monitor) throws IOException, RemoteExecutionException, RemoteSyncException, MissingConnectionException {
        RecursiveSubMonitor subMon = RecursiveSubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            try {
                subMon.subTask(Messages.GitRepo_2);
                CommandRunner.createRemoteDirectory(this.remoteLoc.getConnection(), this.remoteLoc.getDirectory(), (IProgressMonitor)subMon.newChild(2));
            }
            catch (CoreException e) {
                throw new RemoteSyncException((Throwable)e);
            }
            subMon.subTask(Messages.GitRepo_3);
            this.doInit((IProgressMonitor)subMon.newChild(8));
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void doInit(IProgressMonitor monitor) throws IOException, RemoteExecutionException, RemoteSyncException, MissingConnectionException {
        try {
            String commands = String.valueOf(this.gitBinary()) + " --git-dir=" + ".ptp-sync" + " init && " + this.gitBinary() + " --git-dir=" + ".ptp-sync" + " config core.preloadindex true && " + this.gitBinary() + " --git-dir=" + ".ptp-sync" + " config user.email \"" + commitEmail + "\" && " + this.gitBinary() + " --git-dir=" + ".ptp-sync" + " config user.name \"" + commitUserName + "\" && " + this.gitCommand() + " commit --allow-empty -m \"" + GitSyncService.commitMessage + "\"";
            CommandRunner.CommandResults commandResults = null;
            try {
                commandResults = this.executeRemoteCommand(commands, monitor);
            }
            catch (InterruptedException e) {
                throw new RemoteExecutionException((Throwable)e);
            }
            catch (RemoteConnectionException e) {
                throw new RemoteExecutionException((Throwable)e);
            }
            if (commandResults.getExitCode() != 0) {
                throw new RemoteExecutionException(String.valueOf(Messages.GitRepo_5) + commandResults.getStderr());
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public void uploadFilter(JGitRepo localJGitRepo, IProgressMonitor monitor) throws MissingConnectionException, RemoteSyncException {
        block13: {
            RecursiveSubMonitor subMon = RecursiveSubMonitor.convert((IProgressMonitor)monitor, (int)10);
            IRemoteConnection conn = this.remoteLoc.getConnection();
            Repository repository = localJGitRepo.getRepository();
            try {
                File exclude = repository.getFS().resolve(repository.getDirectory(), "info/exclude");
                IFileStore local = EFS.getLocalFileSystem().getStore((IPath)new Path(exclude.getAbsolutePath()));
                String remoteExclude = String.valueOf(this.remoteLoc.getDirectory()) + "/" + ".ptp-sync" + "/" + "info/exclude";
                IFileStore remote = ((IRemoteFileService)conn.getService(IRemoteFileService.class)).getResource(remoteExclude);
                subMon.subTask(Messages.GitRepo_6);
                local.copy(remote, 2, (IProgressMonitor)subMon.newChild(3));
                if (this.remoteGitVersion >= 1080102) {
                    String command = String.valueOf(this.gitCommand()) + " ls-files -X " + ".ptp-sync" + "/" + "info/exclude" + " -i | " + this.gitCommand() + " update-index --force-remove --stdin ; " + this.gitCommand() + " commit --allow-empty -m \"" + GitSyncService.commitMessage + "\"";
                    subMon.subTask(Messages.GitRepo_7);
                    CommandRunner.CommandResults commandResults = this.executeRemoteCommand(command, (IProgressMonitor)subMon.newChild(7));
                    if (commandResults.getExitCode() != 0) {
                        throw new RemoteSyncException(String.valueOf(Messages.GitRepo_8) + commandResults.getStderr());
                    }
                    break block13;
                }
                String command = String.valueOf(this.gitCommand()) + " rev-parse HEAD";
                subMon.subTask(Messages.GitRepo_9);
                CommandRunner.CommandResults commandResults = this.executeRemoteCommand(command, (IProgressMonitor)subMon.newChild(2));
                ObjectId objectId = null;
                if (commandResults.getExitCode() == 0) {
                    objectId = repository.resolve(commandResults.getStdout().trim());
                }
                RevTree ref = null;
                try {
                    if (objectId != null) {
                        ref = new RevWalk(repository).parseTree((AnyObjectId)objectId);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (ref != null) {
                    Set<String> filesToRemove = localJGitRepo.getFilter().getIgnoredFiles(ref);
                    subMon.subTask(Messages.GitRepo_7);
                    this.deleteRemoteFiles(filesToRemove, (IProgressMonitor)subMon.newChild(8));
                }
            }
            catch (RemoteConnectionException e) {
                throw new RemoteSyncException((Throwable)e);
            }
            catch (CoreException e) {
                throw new RemoteSyncException((Throwable)e);
            }
            catch (IOException e) {
                throw new RemoteSyncException((Throwable)e);
            }
            catch (InterruptedException e) {
                throw new RemoteSyncException((Throwable)e);
            }
            catch (RemoteExecutionException e) {
                throw new RemoteSyncException((Throwable)e);
            }
        }
    }

    public void commitRemoteFiles(IProgressMonitor monitor) throws MissingConnectionException, RemoteSyncException {
        try {
            try {
                String command = String.valueOf(this.gitCommand()) + " ls-files -X " + ".ptp-sync" + "/" + "info/exclude" + " -o -m | " + this.gitCommand() + " update-index --add --remove --stdin ; " + this.gitCommand() + " commit -m \"" + GitSyncService.commitMessage + "\"";
                CommandRunner.CommandResults commandResults = this.executeRemoteCommand(command, monitor);
                if (commandResults.getExitCode() != 0 && !commandResults.getStdout().contains("nothing to commit")) {
                    throw new RemoteSyncException(String.valueOf(Messages.GitRepo_11) + commandResults.getStderr());
                }
            }
            catch (InterruptedException e) {
                throw new RemoteSyncException((Throwable)e);
            }
            catch (RemoteConnectionException e) {
                throw new RemoteSyncException((Throwable)e);
            }
            catch (IOException e) {
                throw new RemoteSyncException((Throwable)e);
            }
            catch (CoreException e) {
                throw new RemoteSyncException((Throwable)e);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void deleteRemoteFiles(Set<String> filesToDelete, IProgressMonitor monitor) throws IOException, RemoteExecutionException, RemoteSyncException, MissingConnectionException {
        try {
            while (!filesToDelete.isEmpty()) {
                List<String> commandList = this.stringToList(String.valueOf(this.gitCommand()) + " rm --cached -f --");
                int count = 1;
                String[] stringArray = filesToDelete.toArray(new String[0]);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String fileName = stringArray[n2];
                    if (count++ % 100 == 0) break;
                    commandList.add(fileName);
                    filesToDelete.remove(fileName);
                    ++n2;
                }
                CommandRunner.CommandResults commandResults = null;
                try {
                    commandResults = this.executeRemoteCommand(commandList, monitor);
                }
                catch (InterruptedException e) {
                    throw new RemoteExecutionException((Throwable)e);
                }
                catch (RemoteConnectionException e) {
                    throw new RemoteExecutionException((Throwable)e);
                }
                if (commandResults.getExitCode() == 0) continue;
                throw new RemoteExecutionException(String.valueOf(Messages.GitRepo_12) + commandResults.getStderr());
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public CommandRunner.CommandResults merge(IProgressMonitor monitor) throws RemoteSyncException, MissingConnectionException {
        String command = String.valueOf(this.gitCommand()) + " merge --ff-only " + "ptp-push";
        try {
            return this.executeRemoteCommand(command, monitor);
        }
        catch (IOException e) {
            throw new RemoteSyncException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw new RemoteSyncException((Throwable)e);
        }
        catch (RemoteConnectionException e) {
            throw new RemoteSyncException((Throwable)e);
        }
    }

    private List<String> stringToList(String command) {
        return new ArrayList<String>(Arrays.asList(command.split(" ")));
    }

    public String gitBinary() {
        String gitBinary = "git";
        IScopeContext context = InstanceScope.INSTANCE;
        IEclipsePreferences prefSyncNode = context.getNode(instanceScopeSyncNode);
        if (prefSyncNode == null) {
            Activator.log(Messages.GitRepo_14);
        } else {
            try {
                if (prefSyncNode.nodeExists(GIT_LOCATION_NODE_NAME)) {
                    Preferences prefGitNode = prefSyncNode.node(GIT_LOCATION_NODE_NAME);
                    gitBinary = prefGitNode.get(this.remoteLoc.getConnection().getName(), "git");
                }
            }
            catch (BackingStoreException e) {
                Activator.log(Messages.GitRepo_15, e);
            }
            catch (MissingConnectionException missingConnectionException) {
                // empty catch block
            }
        }
        return gitBinary;
    }

    public String gitCommand() {
        return String.valueOf(this.gitBinary()) + " " + gitArgs;
    }

    public String getHead(IProgressMonitor monitor) throws RemoteSyncException, MissingConnectionException {
        CommandRunner.CommandResults headResults;
        String command = String.valueOf(this.gitCommand()) + " rev-parse HEAD";
        try {
            headResults = this.executeRemoteCommand(command, monitor);
        }
        catch (IOException e) {
            throw new RemoteSyncException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw new RemoteSyncException((Throwable)e);
        }
        catch (RemoteConnectionException e) {
            throw new RemoteSyncException((Throwable)e);
        }
        if (headResults.getExitCode() > 0) {
            return null;
        }
        return headResults.getStdout().trim();
    }

    public RemoteLocation getRemoteLocation() {
        return this.remoteLoc;
    }

    public int getRemoteGitVersion(IProgressMonitor monitor) throws RemoteSyncException, MissingConnectionException {
        String command = String.valueOf(this.gitCommand()) + " --version";
        CommandRunner.CommandResults commandResults = null;
        try {
            try {
                IRemoteConnection conn = this.remoteLoc.getConnection();
                commandResults = CommandRunner.executeRemoteCommand(conn, command, null, monitor);
            }
            catch (InterruptedException e) {
                throw new RemoteSyncException((Throwable)new RemoteExecutionException((Throwable)e));
            }
            catch (RemoteConnectionException e) {
                throw new RemoteSyncException((Throwable)new RemoteExecutionException((Throwable)e));
            }
            catch (IOException e) {
                throw new RemoteSyncException((Throwable)e);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
        if (commandResults.getExitCode() != 0) {
            throw new RemoteSyncException((Throwable)new RemoteExecutionException(String.valueOf(Messages.GitRepo_5) + commandResults.getStderr()));
        }
        Matcher m = Pattern.compile("git version ([0-9]+)\\.([0-9]+)\\.([0-9]+)\\.?([0-9]*)").matcher(commandResults.getStdout().trim());
        if (m.matches()) {
            int patch = 0;
            if (m.group(4).length() > 0) {
                patch = Integer.parseInt(m.group(4));
            }
            return Integer.parseInt(m.group(1)) * 1000000 + Integer.parseInt(m.group(2)) * 10000 + Integer.parseInt(m.group(3)) * 100 + patch;
        }
        return 0;
    }

    private CommandRunner.CommandResults executeRemoteCommand(String command, IProgressMonitor monitor) throws RemoteSyncException, IOException, InterruptedException, RemoteConnectionException, MissingConnectionException {
        IRemoteConnection conn = this.remoteLoc.getConnection();
        String remoteDirectory = this.remoteLoc.getDirectory();
        return CommandRunner.executeRemoteCommand(conn, command, remoteDirectory, monitor);
    }

    private CommandRunner.CommandResults executeRemoteCommand(List<String> command, IProgressMonitor monitor) throws RemoteSyncException, IOException, InterruptedException, RemoteConnectionException, MissingConnectionException {
        IRemoteConnection conn = this.remoteLoc.getConnection();
        String remoteDirectory = this.remoteLoc.getDirectory();
        return CommandRunner.executeRemoteCommand(conn, command, remoteDirectory, monitor);
    }
}

