/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gef.part.menu;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.internal.core.gef.part.menu.MacMenuImageFigure;
import org.eclipse.wb.internal.core.gef.part.menu.MenuEditPart;
import org.eclipse.wb.internal.core.model.menu.IMenuInfo;

public final class MacMenuEditPart
extends MenuEditPart {
    private final IMenuInfo m_menu;
    private boolean m_addedSelf = false;
    private IFigure m_fakeFigure;

    public MacMenuEditPart(Object toolkitModel, IMenuInfo menu) {
        super(toolkitModel, menu);
        this.m_menu = menu;
    }

    @Override
    public IFigure createFigure() {
        return new MacMenuImageFigure(this.m_menu);
    }

    @Override
    protected void refreshVisuals() {
        if (!this.isSubMenu()) {
            Rectangle bounds = this.m_menu.getBounds();
            this.getFigure().setBounds(new Rectangle(MacMenuEditPart.TOP_LOCATION.x, 3, bounds.width, bounds.height));
        } else {
            super.refreshVisuals();
        }
    }

    @Override
    protected boolean addSelfVisual(int index) {
        if (!this.isSubMenu()) {
            LayerManager.Helper.find((EditPartViewer)this.getViewer()).getLayer((Object)"Primary Layer").add(this.getFigure());
            this.m_addedSelf = true;
            GraphicalEditPart parent = (GraphicalEditPart)this.getParent();
            parent.getContentPane().add(this.getFakeFigure(), index);
            return true;
        }
        return false;
    }

    @Override
    protected boolean removeSelfVisual() {
        if (this.m_addedSelf) {
            LayerManager.Helper.find((EditPartViewer)this.getViewer()).getLayer((Object)"Primary Layer").remove(this.getFigure());
            FigureUtils.removeFigure(this.getFakeFigure());
            this.m_addedSelf = false;
            return true;
        }
        return false;
    }

    private IFigure getFakeFigure() {
        if (this.m_fakeFigure == null) {
            this.m_fakeFigure = new Figure();
            this.m_fakeFigure.setVisible(false);
        }
        return this.m_fakeFigure;
    }
}

