/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IConstraint;
import org.eclipse.wst.common.project.facet.core.IGroup;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.IVersionExpr;
import org.eclipse.wst.common.project.facet.core.internal.ProjectFacetRef;
import org.eclipse.wst.common.project.facet.core.internal.ValidationProblem;

public final class Constraint
implements IConstraint {
    private final IProjectFacetVersion fv;
    private final IConstraint.Type type;
    private final List<Object> operands;

    Constraint(IProjectFacetVersion fv, IConstraint.Type type, Object[] operands) {
        this.fv = fv;
        this.type = type;
        ArrayList<Object> temp = new ArrayList<Object>();
        int i = 0;
        while (i < operands.length) {
            temp.add(operands[i]);
            ++i;
        }
        this.operands = Collections.unmodifiableList(temp);
    }

    @Override
    public IConstraint.Type getType() {
        return this.type;
    }

    @Override
    public List<Object> getOperands() {
        return this.operands;
    }

    @Override
    public Object getOperand(int index) {
        return this.operands.get(index);
    }

    @Override
    public IStatus check(Collection<IProjectFacetVersion> facets) {
        return this.check(facets, false);
    }

    @Override
    public IStatus check(Collection<IProjectFacetVersion> facets, boolean validateSoftDeps) {
        MultiStatus result = Constraint.createMultiStatus();
        if (this.type == IConstraint.Type.AND) {
            for (Object operand : this.operands) {
                IConstraint childConstraint = (IConstraint)operand;
                IStatus st = childConstraint.check(facets, validateSoftDeps);
                if (st.getSeverity() == 0) continue;
                result.addAll(st);
            }
        } else if (this.type == IConstraint.Type.OR) {
            boolean someBranchWorks = false;
            for (Object operand : this.operands) {
                IConstraint childConstraint = (IConstraint)operand;
                if (!childConstraint.check(facets, validateSoftDeps).isOK()) continue;
                someBranchWorks = true;
                break;
            }
            if (!someBranchWorks) {
                ValidationProblem p = null;
                if (this.operands.size() == 2 && this.containsOnlyRequires()) {
                    ProjectFacetRef[] frefs = new ProjectFacetRef[2];
                    int i = 0;
                    while (i < 2) {
                        IConstraint c = (IConstraint)this.operands.get(i);
                        IProjectFacet rf = (IProjectFacet)c.getOperand(0);
                        IVersionExpr vexpr = (IVersionExpr)c.getOperand(1);
                        frefs[i] = new ProjectFacetRef(rf, vexpr);
                        ++i;
                    }
                    p = new ValidationProblem(ValidationProblem.Type.REQUIRES_ONE_OF_TWO, this.fv, frefs[0], frefs[1]);
                }
                if (p == null) {
                    p = new ValidationProblem(ValidationProblem.Type.COMPLEX, this.fv);
                }
                result.add(p);
            }
        } else if (this.type == IConstraint.Type.REQUIRES) {
            Boolean soft = (Boolean)this.operands.get(this.operands.size() - 1);
            if (!soft.equals(Boolean.TRUE) || validateSoftDeps) {
                Object firstOperand = this.operands.get(0);
                if (firstOperand instanceof IGroup) {
                    IGroup group = (IGroup)firstOperand;
                    if (!Constraint.containsAny(facets, group.getMembers())) {
                        ValidationProblem.Type ptype = ValidationProblem.Type.REQUIRES_GROUP;
                        ValidationProblem problem = new ValidationProblem(ptype, this.fv, group);
                        result.add((IStatus)problem);
                    }
                } else {
                    IProjectFacet rf = (IProjectFacet)firstOperand;
                    IVersionExpr vexpr = (IVersionExpr)this.operands.get(1);
                    boolean found = false;
                    for (IProjectFacetVersion fv : facets) {
                        if (fv.getProjectFacet() != rf) continue;
                        if (!vexpr.check(fv)) break;
                        found = true;
                        break;
                    }
                    if (!found) {
                        ValidationProblem.Type ptype = ValidationProblem.Type.REQUIRES;
                        ProjectFacetRef fref = new ProjectFacetRef(rf, vexpr);
                        ValidationProblem problem = new ValidationProblem(ptype, this.fv, fref);
                        result.add((IStatus)problem);
                    }
                }
            }
        } else if (this.type == IConstraint.Type.CONFLICTS) {
            Object firstOperand = this.operands.get(0);
            if (firstOperand instanceof IGroup) {
                IGroup group = (IGroup)firstOperand;
                for (IProjectFacetVersion member : group.getMembers()) {
                    if (member.getProjectFacet() == this.fv.getProjectFacet() || !facets.contains(member)) continue;
                    ValidationProblem.Type t = ValidationProblem.Type.CONFLICTS;
                    ValidationProblem problem = new ValidationProblem(t, this.fv, member);
                    result.add((IStatus)problem);
                }
            } else {
                IProjectFacet f = (IProjectFacet)firstOperand;
                IVersionExpr vexpr = this.operands.size() == 2 ? (IVersionExpr)this.operands.get(1) : null;
                for (IProjectFacetVersion fver : facets) {
                    if (fver.getProjectFacet() != f || vexpr != null && !vexpr.check(fver)) continue;
                    ValidationProblem.Type t = ValidationProblem.Type.CONFLICTS;
                    ValidationProblem problem = new ValidationProblem(t, this.fv, fver);
                    result.add((IStatus)problem);
                    break;
                }
            }
        } else {
            throw new IllegalStateException();
        }
        return result;
    }

    public static IConstraint pruneConstraint(IProjectFacetVersion facet, Set<IProjectFacet> fixedFacets) {
        return Constraint.pruneConstraint(facet, facet.getConstraint(), fixedFacets);
    }

    private static IConstraint pruneConstraint(IProjectFacetVersion facet, IConstraint constraint, Set<IProjectFacet> fixedFacets) {
        IConstraint.Type type = constraint.getType();
        if (type == IConstraint.Type.AND || type == IConstraint.Type.OR) {
            ArrayList<IConstraint> newOperands = new ArrayList<IConstraint>();
            boolean changed = false;
            for (Object operand : constraint.getOperands()) {
                IConstraint newOperand = Constraint.pruneConstraint(facet, (IConstraint)operand, fixedFacets);
                if (newOperand == null) {
                    changed = true;
                    continue;
                }
                if (operand != newOperand) {
                    changed = true;
                    newOperands.add(newOperand);
                    continue;
                }
                newOperands.add((IConstraint)operand);
            }
            int newOperandCount = newOperands.size();
            if (newOperandCount == 0) {
                return null;
            }
            if (newOperandCount == 1) {
                return (IConstraint)newOperands.get(0);
            }
            if (changed) {
                return new Constraint(((Constraint)constraint).fv, type, newOperands.toArray());
            }
        } else if (type == IConstraint.Type.REQUIRES) {
            Object firstOperand = constraint.getOperand(0);
            if (firstOperand instanceof IProjectFacet) {
                IProjectFacet f = (IProjectFacet)firstOperand;
                IVersionExpr vexpr = (IVersionExpr)constraint.getOperand(1);
                int acceptableVersionCount = 0;
                for (IProjectFacetVersion fv : f.getVersions()) {
                    if (!vexpr.check(fv) || !fv.isValidFor(fixedFacets)) continue;
                    ++acceptableVersionCount;
                }
                if (acceptableVersionCount == 0) {
                    return null;
                }
                if (fixedFacets.contains(f) && f.getVersions().size() == acceptableVersionCount) {
                    return null;
                }
            }
        } else if (type == IConstraint.Type.CONFLICTS) {
            Object firstOperand = constraint.getOperand(0);
            if (firstOperand instanceof IProjectFacet) {
                IProjectFacet f = (IProjectFacet)firstOperand;
                IVersionExpr vexpr = (IVersionExpr)constraint.getOperand(1);
                boolean isValidForContext = false;
                for (IProjectFacetVersion fv : f.getVersions()) {
                    if (!vexpr.check(fv) || !fv.isValidFor(fixedFacets)) continue;
                    isValidForContext = true;
                    break;
                }
                if (!isValidForContext) {
                    return null;
                }
            } else if (firstOperand instanceof IGroup) {
                IGroup group = (IGroup)firstOperand;
                boolean atLeastOneIsValid = false;
                for (IProjectFacetVersion member : group.getMembers()) {
                    if (member.getProjectFacet() == facet.getProjectFacet() || !member.isValidFor(fixedFacets)) continue;
                    atLeastOneIsValid = true;
                    break;
                }
                if (!atLeastOneIsValid) {
                    return null;
                }
            }
        }
        return constraint;
    }

    private boolean containsOnlyRequires() {
        for (Object operand : this.operands) {
            if (((IConstraint)operand).getType() == IConstraint.Type.REQUIRES) continue;
            return false;
        }
        return true;
    }

    private static boolean containsAny(Collection<? extends Object> a, Collection<? extends Object> b) {
        for (Object object : a) {
            if (!b.contains(object)) continue;
            return true;
        }
        return false;
    }

    static MultiStatus createMultiStatus() {
        return Constraint.createMultiStatus(new IStatus[0]);
    }

    public static MultiStatus createMultiStatus(IStatus[] children) {
        return new MultiStatus("org.eclipse.wst.common.project.facet.core", 0, children, Resources.validationProblems, null);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.type.name());
        buf.append("( ");
        boolean isFirst = true;
        for (Object operand : this.operands) {
            if (isFirst) {
                isFirst = false;
            } else {
                buf.append(", ");
            }
            buf.append(operand.toString());
        }
        buf.append(" )");
        return buf.toString();
    }

    private static final class Resources
    extends NLS {
        public static String validationProblems;

        static {
            Resources.initializeMessages((String)Constraint.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

