/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.visitor;

import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.BindingOperation;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Fault;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.Output;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.Port;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.Service;

public class WSDLVisitor {
    protected Definition definition;

    public WSDLVisitor(Definition definition) {
        this.definition = definition;
    }

    public void visitDefinition() {
        this.visitBindings();
        this.visitMessages();
        this.visitPortTypes();
        this.visitServices();
    }

    public void visitBindings() {
        for (Binding binding : this.definition.getEBindings()) {
            this.visitBinding(binding);
        }
    }

    public void visitMessages() {
        for (Message message : this.definition.getEMessages()) {
            this.visitMessage(message);
        }
    }

    public void visitPortTypes() {
        for (PortType portType : this.definition.getEPortTypes()) {
            this.visitPortType(portType);
        }
    }

    public void visitServices() {
        for (Service service : this.definition.getEServices()) {
            this.visitService(service);
        }
    }

    public void visitBinding(Binding binding) {
        PortType portType = binding.getEPortType();
        if (portType != null) {
            this.visitPortType(portType);
        }
        for (BindingOperation bindingOperation : binding.getEBindingOperations()) {
            this.visitBindingOperation(bindingOperation);
        }
    }

    public void visitPortType(PortType portType) {
        for (Operation operation : portType.getEOperations()) {
            this.visitOperation(operation);
        }
    }

    public void visitBindingOperation(BindingOperation bindingOperation) {
    }

    public void visitOperation(Operation operation) {
        Input input = operation.getEInput();
        Output output = operation.getEOutput();
        if (input != null) {
            this.visitInput(input);
        }
        if (output != null) {
            this.visitOutput(output);
        }
        for (Fault fault : operation.getEFaults()) {
            if (fault == null) continue;
            this.visitFault(fault);
        }
    }

    public void visitPart(Part part) {
    }

    public void visitMessage(Message message) {
        for (Part part : message.getEParts()) {
            this.visitPart(part);
        }
    }

    public void visitInput(Input input) {
        Message message = input.getEMessage();
        if (message != null) {
            this.visitMessage(message);
        }
    }

    public void visitOutput(Output output) {
        Message message = output.getEMessage();
        if (message != null) {
            this.visitMessage(message);
        }
    }

    public void visitFault(Fault fault) {
        Message message = fault.getEMessage();
        if (message != null) {
            this.visitMessage(message);
        }
    }

    public void visitPort(Port port) {
        Binding binding = port.getEBinding();
        if (binding != null) {
            this.visitBinding(binding);
        }
    }

    public void visitService(Service service) {
        for (Port port : service.getEPorts()) {
            this.visitPort(port);
        }
    }
}

