/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common.ide.authoring;

import com.google.common.io.Closeables;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.common.AcceleoCommonMessages;
import org.eclipse.acceleo.common.AcceleoCommonPlugin;
import org.eclipse.acceleo.common.ide.authoring.AcceleoProjectInfo;
import org.eclipse.acceleo.common.ide.authoring.AcceleoProjectState;
import org.eclipse.acceleo.common.internal.utils.AcceleoLogger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public final class AcceleoModelManager
implements ISaveParticipant {
    private static final AcceleoModelManager MANAGER = new AcceleoModelManager();
    private Map<IProject, AcceleoProjectInfo> acceleoProjectInfos = new HashMap<IProject, AcceleoProjectInfo>();

    private AcceleoModelManager() {
    }

    public static AcceleoModelManager getManager() {
        return MANAGER;
    }

    public void startup() {
        try {
            AcceleoCommonPlugin.getDefault().getStateLocation();
            final IWorkspace workspace = ResourcesPlugin.getWorkspace();
            Job processSavedState = new Job(AcceleoCommonMessages.getString((String)"AcceleoModelManager.ProcessingAcceleoChanges")){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        workspace.run(new IWorkspaceRunnable(){

                            public void run(IProgressMonitor progress) throws CoreException {
                                workspace.addSaveParticipant("org.eclipse.acceleo.common", (ISaveParticipant)AcceleoModelManager.this);
                            }
                        }, monitor);
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                    return Status.OK_STATUS;
                }
            };
            processSavedState.setSystem(true);
            processSavedState.setPriority(20);
            processSavedState.schedule();
        }
        catch (RuntimeException e) {
            this.shutdown();
            throw e;
        }
    }

    public void shutdown() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeSaveParticipant("org.eclipse.acceleo.common");
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
    }

    public void saving(ISaveContext context) throws CoreException {
        IProject savedProject = context.getProject();
        if (savedProject != null && savedProject.isAccessible() && savedProject.hasNature("org.eclipse.acceleo.ide.ui.acceleoNature")) {
            AcceleoProjectInfo info = this.getAcceleoProjectInfo(savedProject, true);
            this.saveState(info, context);
        }
        Set<Map.Entry<IProject, AcceleoProjectInfo>> entrySet = this.acceleoProjectInfos.entrySet();
        for (Map.Entry<IProject, AcceleoProjectInfo> entry : entrySet) {
            IProject project = entry.getKey();
            if (project == null || !project.isAccessible() || !project.hasNature("org.eclipse.acceleo.ide.ui.acceleoNature")) continue;
            AcceleoProjectInfo info = entry.getValue();
            this.saveState(info, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AcceleoProjectInfo getAcceleoProjectInfo(IProject project, boolean create) {
        Map<IProject, AcceleoProjectInfo> map = this.acceleoProjectInfos;
        synchronized (map) {
            AcceleoProjectInfo info = this.acceleoProjectInfos.get(project);
            if (info == null && create) {
                info = new AcceleoProjectInfo(project);
                this.acceleoProjectInfos.put(project, info);
            }
            return info;
        }
    }

    private void saveState(AcceleoProjectInfo info, ISaveContext context) {
        if (2 == context.getKind()) {
            return;
        }
        if (info.hasBeenRead()) {
            this.saveBuiltState(info);
        }
    }

    public void setProjectState(IProject project, AcceleoProjectState state) {
        block6: {
            try {
                if (project.isAccessible() && project.hasNature("org.eclipse.acceleo.ide.ui.acceleoNature")) {
                    AcceleoProjectInfo info = this.getAcceleoProjectInfo(project, true);
                    info.markAsRead();
                    info.setSavedState(state);
                }
                if (state != null) break block6;
                try {
                    File file = this.getSerializationFile(project);
                    if (file != null && file.exists()) {
                        file.delete();
                    }
                }
                catch (SecurityException file) {}
            }
            catch (CoreException e) {
                AcceleoLogger.log((Exception)((Object)e), (boolean)true);
            }
        }
    }

    private void saveBuiltState(AcceleoProjectInfo info) {
        File file = this.getSerializationFile(info.getProject());
        if (file == null) {
            return;
        }
        try {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            try {
                out.writeUTF("org.eclipse.acceleo.common");
                out.writeUTF("STATE");
                if (info.getSavedState() == null) {
                    out.writeBoolean(false);
                } else {
                    out.writeBoolean(true);
                    AcceleoModelManager.writeState(info.getSavedState(), out);
                }
            }
            finally {
                Closeables.close((Closeable)out, (boolean)true);
            }
        }
        catch (RuntimeException e) {
            try {
                file.delete();
            }
            catch (SecurityException securityException) {}
        }
        catch (IOException e) {
            try {
                file.delete();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    public AcceleoProjectState getLastBuiltState(IProject project, IProgressMonitor monitor) {
        try {
            if (project.isAccessible() && project.hasNature("org.eclipse.acceleo.ide.ui.acceleoNature")) {
                AcceleoProjectInfo info = this.getAcceleoProjectInfo(project, true);
                if (!info.hasBeenRead()) {
                    info.markAsRead();
                    info.setSavedState(this.readBuiltState(project));
                }
                return info.getSavedState();
            }
        }
        catch (CoreException e) {
            AcceleoLogger.log((Exception)((Object)e), (boolean)true);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AcceleoProjectState readBuiltState(IProject project) {
        File file = this.getSerializationFile(project);
        if (file == null) return null;
        if (!file.exists()) return null;
        try (DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));){
            String kind;
            String pluginID = in.readUTF();
            if (!pluginID.equals("org.eclipse.acceleo.common")) {
                AcceleoLogger.log((String)AcceleoCommonMessages.getString((String)"AcceleoModelManager.WrongFileFormat"), (boolean)true);
            }
            if (!"STATE".equals(kind = in.readUTF())) {
                AcceleoLogger.log((String)AcceleoCommonMessages.getString((String)"AcceleoModelManager.WrongFileFormat"), (boolean)true);
            }
            if (!in.readBoolean()) return null;
            AcceleoProjectState acceleoProjectState = AcceleoModelManager.readState(project, in);
            return acceleoProjectState;
        }
        catch (Exception e) {
            AcceleoLogger.log((Exception)e, (boolean)true);
        }
        return null;
    }

    public static void writeState(AcceleoProjectState savedState, DataOutputStream out) {
        try {
            savedState.write(out);
        }
        catch (IOException e) {
            AcceleoLogger.log((Exception)e, (boolean)true);
        }
    }

    public static AcceleoProjectState readState(IProject project, DataInputStream in) {
        try {
            return AcceleoProjectState.read(project, in);
        }
        catch (IOException e) {
            AcceleoLogger.log((Exception)e, (boolean)true);
            return null;
        }
    }

    private File getSerializationFile(IProject project) {
        if (!project.exists()) {
            return null;
        }
        IPath workingLocation = project.getWorkingLocation("org.eclipse.acceleo.common");
        return workingLocation.append("acceleo.state.dat").toFile();
    }

    public void doneSaving(ISaveContext context) {
    }

    public void rollback(ISaveContext context) {
    }
}

