/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.ui.composites;

import org.eclipse.emf.cdo.dawn.ui.views.DawnWizardPageItemProvider;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.ui.views.ContainerItemProvider;
import org.eclipse.net4j.util.ui.views.IElementFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class CDOResourceNodeSelectionWidget
extends Composite {
    private ContainerItemProvider<IContainer<Object>> itemProvider;
    private ShowResourcesViewFilter viewFilter;
    private TreeViewer viewer;

    public CDOResourceNodeSelectionWidget(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.init();
    }

    public void setShowResources(boolean showResources) {
        this.viewFilter.setShowResources(showResources);
    }

    protected void init() {
        this.viewer = new TreeViewer((Composite)this, 2818);
        this.itemProvider = this.createContainerItemProvider();
        this.viewer.setContentProvider(this.createContentProvider());
        this.viewer.setLabelProvider(this.createLabelProvider());
        this.viewer.getTree().setLayoutData((Object)new GridData(1808));
        this.viewer.setInput((Object)this.getManagedContainer());
        this.viewFilter = new ShowResourcesViewFilter();
        this.viewer.addFilter((ViewerFilter)this.viewFilter);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.viewer.addSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.viewer.removeSelectionChangedListener(listener);
    }

    protected IManagedContainer getManagedContainer() {
        return IPluginContainer.INSTANCE;
    }

    protected IContentProvider createContentProvider() {
        return this.itemProvider;
    }

    protected IBaseLabelProvider createLabelProvider() {
        ILabelDecorator labelDecorator = this.createLabelDecorator();
        return new DecoratingLabelProvider(this.itemProvider, labelDecorator);
    }

    protected ILabelDecorator createLabelDecorator() {
        return PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
    }

    protected ContainerItemProvider<IContainer<Object>> createContainerItemProvider() {
        return new DawnWizardPageItemProvider(new IElementFilter(){

            public boolean filter(Object element) {
                return element instanceof CDOSession;
            }
        });
    }

    protected class ShowResourcesViewFilter
    extends ViewerFilter {
        private boolean showResources;

        protected ShowResourcesViewFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof CDOResource) {
                return this.isShowResources();
            }
            return true;
        }

        public void setShowResources(boolean showResources) {
            this.showResources = showResources;
        }

        public boolean isShowResources() {
            return this.showResources;
        }
    }
}

