/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.internal;

import java.net.URL;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.jst.server.core.Servlet;
import org.eclipse.jst.server.tomcat.core.internal.TomcatServer;
import org.eclipse.jst.server.tomcat.core.internal.Trace;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.model.IURLProvider;
import org.eclipse.wst.server.core.model.LaunchableAdapterDelegate;
import org.eclipse.wst.server.core.util.HttpLaunchable;
import org.eclipse.wst.server.core.util.WebResource;

public class TomcatLaunchableAdapterDelegate
extends LaunchableAdapterDelegate {
    public Object getLaunchable(IServer server, IModuleArtifact moduleObject) {
        Trace.trace((byte)4, "TomcatLaunchableAdapter " + String.valueOf(server) + "-" + String.valueOf(moduleObject));
        if (server.getAdapter(TomcatServer.class) == null) {
            return null;
        }
        if (!(moduleObject instanceof Servlet) && !(moduleObject instanceof WebResource)) {
            return null;
        }
        if (moduleObject.getModule().loadAdapter(IWebModule.class, null) == null) {
            return null;
        }
        try {
            URL url = ((IURLProvider)server.loadAdapter(IURLProvider.class, null)).getModuleRootURL(moduleObject.getModule());
            Trace.trace((byte)4, "root: " + String.valueOf(url));
            if (moduleObject instanceof Servlet) {
                Servlet servlet = (Servlet)moduleObject;
                if (servlet.getAlias() != null) {
                    String path = servlet.getAlias();
                    if (path.startsWith("/")) {
                        path = path.substring(1);
                    }
                    url = new URL(url, path);
                } else {
                    url = new URL(url, "servlet/" + servlet.getServletClassName());
                }
            } else if (moduleObject instanceof WebResource) {
                WebResource resource = (WebResource)moduleObject;
                String path = resource.getPath().toString();
                Trace.trace((byte)4, "path: " + path);
                if (path != null && path.startsWith("/") && path.length() > 0) {
                    path = path.substring(1);
                }
                if (path != null && path.length() > 0) {
                    url = new URL(url, path);
                }
            }
            return new HttpLaunchable(url);
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Error getting URL for " + String.valueOf(moduleObject), e);
            return null;
        }
    }
}

