/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.metamodel.helper;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.common.tools.api.util.EqualityHelper;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramComponentizationManager;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManager;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.DiagramComponentizationHelper;
import org.eclipse.sirius.diagram.description.AdditionalLayer;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.model.business.internal.helper.LayerModelHelper;
import org.eclipse.sirius.diagram.model.business.internal.helper.MappingHelper;
import org.eclipse.sirius.viewpoint.description.AbstractMappingImport;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public final class LayerHelper {
    private static final String ENABLE_ACTIVE_PARENT_LAYERS_OPTIMIZATION_SYSTEM_PROPERTY = "org.eclipse.sirius.diagram.enableActiveParentLayersOptimization";
    private static final Map<DiagramMappingsManager, Map<DiagramElementMapping, Collection<Layer>>> ACTIVE_PARENT_LAYER_CACHE = new ConcurrentHashMap<DiagramMappingsManager, Map<DiagramElementMapping, Collection<Layer>>>();

    private LayerHelper() {
    }

    public static Collection<Layer> getParentLayers(DiagramElementMapping mapping) {
        LinkedHashSet<Layer> layers = new LinkedHashSet<Layer>();
        Layer parentLayer = LayerModelHelper.getContainingLayer((DiagramElementMapping)mapping);
        if (parentLayer != null) {
            layers.add(parentLayer);
        }
        EObject registryMappingInstance = ViewpointRegistry.getInstance().find((EObject)mapping);
        Collection settings = ViewpointRegistry.getInstance().getCrossReferencer().getInverseReferences(registryMappingInstance);
        for (EStructuralFeature.Setting setting : settings) {
            EObject eReferencer = setting.getEObject();
            EStructuralFeature eFeature = setting.getEStructuralFeature();
            if (eReferencer instanceof Layer && eFeature.equals(DescriptionPackage.eINSTANCE.getLayer_ReusedMappings())) {
                layers.add((Layer)eReferencer);
                continue;
            }
            if (!eFeature.equals(DescriptionPackage.eINSTANCE.getContainerMapping_ReusedNodeMappings()) && !eFeature.equals(DescriptionPackage.eINSTANCE.getContainerMapping_ReusedContainerMappings()) && !eFeature.equals(DescriptionPackage.eINSTANCE.getAbstractNodeMapping_ReusedBorderedNodeMappings())) continue;
            Layer eReferencerLayer = LayerModelHelper.getContainingLayer((DiagramElementMapping)((DiagramElementMapping)eReferencer));
            Layer mappingSourceLayer = LayerModelHelper.getContainingLayer((DiagramElementMapping)mapping);
            if (eReferencerLayer == null || layers.contains(eReferencerLayer) || EqualityHelper.areEquals((EObject)mappingSourceLayer.eContainer(), (EObject)eReferencerLayer.eContainer())) continue;
            layers.add(eReferencerLayer);
        }
        if (mapping.eContainer() instanceof ContainerMapping) {
            layers.addAll(LayerHelper.getParentLayers((DiagramElementMapping)((ContainerMapping)mapping.eContainer())));
        }
        return layers;
    }

    public static boolean isInActivatedLayer(DiagramMappingsManager mappingsManager, DDiagramElement element) {
        return LayerHelper.isInActivatedLayer(mappingsManager, element, element.getParentDiagram());
    }

    public static boolean isInActivatedLayer(DiagramMappingsManager mappingsManager, DDiagramElement element, DDiagram parentDiagram) {
        DiagramElementMapping mapping = element.getDiagramElementMapping();
        if (!LayerModelHelper.withoutLayersMode((DiagramElementMapping)mapping)) {
            DDiagram diagram = parentDiagram != null ? parentDiagram : element.getParentDiagram();
            boolean visible = false;
            if (diagram != null && LayerHelper.getActiveParentLayers(mappingsManager, mapping).size() > 0) {
                EObject registryMappingInstance = ViewpointRegistry.getInstance().find((EObject)mapping);
                Collection settings = ViewpointRegistry.getInstance().getCrossReferencer().getInverseReferences(registryMappingInstance, true);
                if (!LayerHelper.hideSubMappingsInImporters(mappingsManager, diagram, settings, mapping)) {
                    EObject container = element.eContainer();
                    if (container instanceof DDiagramElement && LayerHelper.isInActivatedLayer(mappingsManager, (DDiagramElement)container, parentDiagram)) {
                        visible = LayerHelper.caseDiagramElementContainer((DDiagramElement)container, mapping);
                    } else if (container instanceof DDiagram) {
                        visible = LayerHelper.caseDiagramContainer(diagram, mapping);
                    } else if (container == null) {
                        visible = LayerHelper.caseDiagramContainer(parentDiagram, mapping);
                    }
                }
            }
            return visible;
        }
        return true;
    }

    private static boolean caseDiagramElementContainer(DDiagramElement container, DiagramElementMapping mapping) {
        DiagramElementMapping containerMapping = container.getDiagramElementMapping();
        return MappingHelper.getAllMappings((DiagramElementMapping)containerMapping).contains((Object)mapping);
    }

    private static boolean caseDiagramContainer(DDiagram diagram, DiagramElementMapping mapping) {
        for (Layer activatedLayer : diagram.getActivatedLayers()) {
            if (!EqualityHelper.contains((Collection)LayerModelHelper.getAllLayerMappings((Layer)activatedLayer), (EObject)mapping)) continue;
            return true;
        }
        return false;
    }

    private static boolean hideSubMappingsInImporters(DiagramMappingsManager session, DDiagram diagram, Collection<EStructuralFeature.Setting> settings, DiagramElementMapping mapping) {
        boolean hide = false;
        for (EStructuralFeature.Setting setting : settings) {
            EObject eObject = setting.getEObject();
            EStructuralFeature eFeature = setting.getEStructuralFeature();
            if (!(eObject instanceof AbstractMappingImport) || !(eObject instanceof DiagramElementMapping) || eFeature != DescriptionPackage.eINSTANCE.getContainerMappingImport_ImportedMapping() && eFeature != DescriptionPackage.eINSTANCE.getNodeMappingImport_ImportedMapping()) continue;
            DiagramElementMapping importerMapping = (DiagramElementMapping)eObject;
            if (((AbstractMappingImport)importerMapping).isHideSubMappings() && LayerHelper.isInActivatedLayer(session, diagram, importerMapping)) {
                hide = true;
                break;
            }
            Collection importerSettings = ViewpointRegistry.getInstance().getCrossReferencer().getInverseReferences((EObject)importerMapping);
            if (!LayerHelper.hideSubMappingsInImporters(session, diagram, importerSettings, importerMapping)) continue;
            hide = true;
            break;
        }
        return hide;
    }

    public static boolean isInActivatedLayer(DiagramMappingsManager mappingsManager, DDiagram diagram, DiagramElementMapping mapping) {
        if (!LayerModelHelper.withoutLayersMode((DiagramElementMapping)mapping)) {
            boolean visible = false;
            Collection<Layer> layers = LayerHelper.getActiveParentLayers(mappingsManager, mapping);
            for (Layer layer : layers) {
                if (!EqualityHelper.contains((Collection)diagram.getActivatedLayers(), (EObject)layer)) continue;
                EObject registryMappingInstance = ViewpointRegistry.getInstance().find((EObject)mapping);
                Collection settings = ViewpointRegistry.getInstance().getCrossReferencer().getInverseReferences(registryMappingInstance);
                if (LayerHelper.hideSubMappingsInImporters(mappingsManager, diagram, settings, mapping)) continue;
                visible = true;
                break;
            }
            return visible;
        }
        return true;
    }

    public static synchronized void setActiveParentLayersCacheEnabled(DiagramMappingsManager mappingsManager, boolean enable) {
        if (!Boolean.valueOf(System.getProperty(ENABLE_ACTIVE_PARENT_LAYERS_OPTIMIZATION_SYSTEM_PROPERTY, "true")).booleanValue()) {
            return;
        }
        if (enable && !ACTIVE_PARENT_LAYER_CACHE.containsKey(mappingsManager)) {
            ACTIVE_PARENT_LAYER_CACHE.put(mappingsManager, new ConcurrentHashMap());
        }
        if (!enable) {
            ACTIVE_PARENT_LAYER_CACHE.remove(mappingsManager);
        }
    }

    private static Collection<Layer> getActiveParentLayers(DiagramMappingsManager mappingsManager, DiagramElementMapping mapping) {
        Map<DiagramElementMapping, Collection<Layer>> managerCache = ACTIVE_PARENT_LAYER_CACHE.get(mappingsManager);
        if (managerCache != null) {
            Collection<Layer> cachedValue = managerCache.get(mapping);
            if (cachedValue == null) {
                cachedValue = mappingsManager.getActiveParentLayers(mapping);
                managerCache.put(mapping, cachedValue);
            }
            return cachedValue;
        }
        return mappingsManager.getActiveParentLayers(mapping);
    }

    public static void updateActualMapping(DDiagramElement element, DiagramElementMapping mapping) {
        DDiagramElementContainer ddec;
        if (element instanceof DNode && mapping instanceof NodeMapping) {
            DNode node = (DNode)element;
            if (node.getActualMapping() != mapping) {
                node.setActualMapping((NodeMapping)mapping);
            }
        } else if (element instanceof DDiagramElementContainer && mapping instanceof ContainerMapping && (ddec = (DDiagramElementContainer)element).getActualMapping() != mapping) {
            ddec.setActualMapping((ContainerMapping)mapping);
        }
    }

    public static void getInitialActiveLayers(DiagramDescription diagDescription, Collection<Viewpoint> viewpointsFilter, List<Layer> layersToActivate, List<AdditionalLayer> transientLayersToActivate) {
        Predicate<Layer> isActiveByDefault = new Predicate<Layer>(){

            public boolean apply(Layer layer) {
                boolean result = true;
                if (layer instanceof AdditionalLayer) {
                    AdditionalLayer additionalLayer = (AdditionalLayer)layer;
                    result = additionalLayer.isActiveByDefault() || !additionalLayer.isOptional();
                }
                return result;
            }
        };
        LayerHelper.getFilteredLayers(diagDescription, viewpointsFilter, layersToActivate, transientLayersToActivate, isActiveByDefault);
    }

    private static void getFilteredLayers(DiagramDescription diagDescription, Collection<Viewpoint> viewpointsFilter, List<Layer> layers, List<AdditionalLayer> transientLayers, Predicate<Layer> predicate) {
        ArrayList<Layer> allLayers = new ArrayList<Layer>((Collection<Layer>)new DiagramComponentizationManager().getAllLayers(viewpointsFilter, diagDescription));
        Collection allActivatedLayers = Collections2.filter(allLayers, predicate);
        allActivatedLayers.addAll(Collections2.filter(DiagramComponentizationHelper.getContributedLayers(diagDescription, viewpointsFilter), predicate));
        for (Layer layer : allActivatedLayers) {
            if (LayerModelHelper.isTransientLayer((Layer)layer)) {
                transientLayers.add((AdditionalLayer)layer);
                continue;
            }
            layers.add(layer);
        }
    }

    public static void getMandatoriesAdditionalLayers(DiagramDescription diagDescription, Collection<Viewpoint> viewpointsFilter, List<Layer> layers, List<AdditionalLayer> transientLayers) {
        Predicate<Layer> isMandatory = new Predicate<Layer>(){

            public boolean apply(Layer layer) {
                return layer instanceof AdditionalLayer && !((AdditionalLayer)layer).isOptional();
            }
        };
        LayerHelper.getFilteredLayers(diagDescription, viewpointsFilter, layers, transientLayers, isMandatory);
    }
}

