/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl;

import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.FieldLoadedFinisher;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.JavaCodeGenerator;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.ObjectData;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.RefToType;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.SlowParser;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.TypeHandler;

class JsonTypeParser<T>
extends SlowParser<ObjectData> {
    private final RefToType<T> refToType;
    private final boolean isNullable;
    private final boolean isSubtyping;
    private static final FieldLoadedFinisher VALUE_FINISHER = new FieldLoadedFinisher(){

        @Override
        Object getValueForUser(Object cachedValue) {
            if (cachedValue == null) {
                return null;
            }
            ObjectData data = (ObjectData)cachedValue;
            return data.getProxy();
        }
    };

    JsonTypeParser(RefToType<T> refToType, boolean isNullable, boolean isSubtyping) {
        this.refToType = refToType;
        this.isNullable = isNullable;
        this.isSubtyping = isSubtyping;
    }

    RefToType<T> getType() {
        return this.refToType;
    }

    @Override
    public ObjectData parseValue(Object value, ObjectData thisData) throws JsonProtocolParseException {
        if (this.isNullable && value == null) {
            return null;
        }
        if (value == null) {
            throw new JsonProtocolParseException("null input");
        }
        TypeHandler<T> typeHandler = this.refToType.get();
        if (this.isSubtyping) {
            return typeHandler.parse(value, thisData);
        }
        return typeHandler.parseRootImpl(value);
    }

    @Override
    public FieldLoadedFinisher getValueFinisher() {
        return VALUE_FINISHER;
    }

    @Override
    public JsonTypeParser<?> asJsonTypeParser() {
        return this;
    }

    public boolean isSubtyping() {
        return this.isSubtyping;
    }

    @Override
    public void appendFinishedValueTypeNameJava(JavaCodeGenerator.FileScope scope) {
        scope.append(this.refToType.getTypeClass().getCanonicalName());
    }

    @Override
    public void appendInternalValueTypeNameJava(JavaCodeGenerator.FileScope classScope) {
        classScope.append(classScope.getTypeImplReference(this.refToType.get()));
    }

    @Override
    void writeParseCode(JavaCodeGenerator.MethodScope scope, String valueRef, String superValueRef, String resultRef) {
        String typeName = scope.getTypeImplReference(this.refToType.get());
        scope.startLine(String.valueOf(typeName) + " " + resultRef + ";\n");
        scope.startLine("if (" + valueRef + " == null) {\n");
        if (this.isNullable) {
            scope.startLine("  " + resultRef + " = null;\n");
        } else {
            scope.startLine("  throw new org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException(\"null input\");\n");
        }
        scope.startLine("} else {\n");
        if (this.isSubtyping) {
            scope.startLine("  " + resultRef + " = new " + typeName + "(" + valueRef + ", " + superValueRef + ");\n");
        } else {
            scope.startLine("  " + resultRef + " = " + typeName + ".parse(" + valueRef + ");\n");
        }
        scope.startLine("}\n");
    }

    @Override
    boolean javaCodeThrowsException() {
        return true;
    }
}

