/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.test.assertj.bundlecontext;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AssertFactory;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.InstanceOfAssertFactory;
import org.assertj.core.api.ListAssert;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.test.assertj.bundle.BundleAssert;
import org.osgi.test.assertj.bundlereference.AbstractBundleReferenceAssert;

public abstract class AbstractBundleContextAssert<SELF extends AbstractBundleContextAssert<SELF, ACTUAL>, ACTUAL extends BundleContext>
extends AbstractBundleReferenceAssert<SELF, ACTUAL> {
    static InstanceOfAssertFactory<List, ListAssert<Bundle>> BUNDLE_LIST = InstanceOfAssertFactories.list(Bundle.class);

    protected AbstractBundleContextAssert(ACTUAL actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public SELF hasProperty(String key) {
        this.isNotNull();
        if (((BundleContext)this.actual).getProperty(key) == null) {
            throw this.failure("%nExpecting%n <%s>%nto have property:%n <%s>%n but it did not", new Object[]{this.actual, key});
        }
        return (SELF)((Object)((AbstractBundleContextAssert)this.myself));
    }

    public AbstractStringAssert<?> hasPropertyWithKeyThat(String key) {
        return (AbstractStringAssert)((AbstractStringAssert)((AbstractBundleContextAssert)this.isNotNull()).extracting(bundleContext -> bundleContext.getProperty(key), (AssertFactory)InstanceOfAssertFactories.STRING)).as(this.actual + ".property(" + key + ")", new Object[0]);
    }

    public SELF doesNotHaveProperty(String key) {
        this.isNotNull();
        String value = ((BundleContext)this.actual).getProperty(key);
        if (value != null) {
            throw this.failure("%nExpecting%n  <%s>%nto not have property:%n  <%s>%n but it did:%n  <%s>", new Object[]{this.actual, key, value});
        }
        return (SELF)((Object)((AbstractBundleContextAssert)this.myself));
    }

    public SELF hasBundleWithId(long id) {
        this.isNotNull();
        if (((BundleContext)this.actual).getBundle(id) == null) {
            throw this.failure("%nExpecting%n <%s>%nto have bundle with id:%n <%d>%n but it did not", new Object[]{this.actual, id});
        }
        return (SELF)((Object)((AbstractBundleContextAssert)this.myself));
    }

    public BundleAssert hasBundleWithIdThat(long id) {
        return (BundleAssert)((Object)((BundleAssert)((AbstractBundleContextAssert)this.isNotNull()).extracting(bundleContext -> bundleContext.getBundle(id), (AssertFactory)BundleAssert.BUNDLE)).as(this.actual + ".bundle(" + id + ")", new Object[0]));
    }

    public SELF doesNotHaveBundleWithId(long id) {
        this.isNotNull();
        Bundle value = ((BundleContext)this.actual).getBundle(id);
        if (value != null) {
            throw this.failure("%nExpecting%n  <%s>%nto not have bundle with id:%n  <%d>%n but it did:%n  <%s>", new Object[]{this.actual, id, value});
        }
        return (SELF)((Object)((AbstractBundleContextAssert)this.myself));
    }

    public SELF hasBundleWithLocation(String location) {
        this.isNotNull();
        if (((BundleContext)this.actual).getBundle(location) == null) {
            throw this.failure("%nExpecting%n <%s>%nto have bundle with location:%n <%s>%n but it did not", new Object[]{this.actual, location});
        }
        return (SELF)((Object)((AbstractBundleContextAssert)this.myself));
    }

    public BundleAssert hasBundleWithLocationThat(String location) {
        return (BundleAssert)((Object)((BundleAssert)((AbstractBundleContextAssert)this.isNotNull()).extracting(bundleContext -> bundleContext.getBundle(location), (AssertFactory)BundleAssert.BUNDLE)).as(this.actual + ".bundle(" + location + ")", new Object[0]));
    }

    public SELF doesNotHaveBundleWithLocation(String location) {
        this.isNotNull();
        Bundle value = ((BundleContext)this.actual).getBundle(location);
        if (value != null) {
            throw this.failure("%nExpecting%n  <%s>%nto not have bundle with location:%n  <%s>%n but it did:%n  <%s>", new Object[]{this.actual, location, value});
        }
        return (SELF)((Object)((AbstractBundleContextAssert)this.myself));
    }

    public ListAssert<Bundle> hasBundlesThat() {
        return (ListAssert)((ListAssert)((AbstractBundleContextAssert)this.isNotNull()).extracting(bundleContext -> Arrays.asList(bundleContext.getBundles()), (AssertFactory)BUNDLE_LIST)).as(this.actual + ".bundles", new Object[0]);
    }
}

