/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice.util;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.internal.remoteservice.Activator;
import org.eclipse.ecf.remoteservice.IRemoteFilter;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class RemoteFilterImpl
implements IRemoteFilter {
    public static final String REMOTE_SERVICEID_PREFIX = "(&(ecf.rsvc.id=";
    Filter filter;
    long rsId = 0L;

    public RemoteFilterImpl(String createFilter) throws InvalidSyntaxException {
        this(Activator.getDefault().getContext(), createFilter);
    }

    private void parseForRsId(String createFilter) {
        if (createFilter == null) {
            return;
        }
        if (createFilter.startsWith(REMOTE_SERVICEID_PREFIX)) {
            String f = createFilter.substring(REMOTE_SERVICEID_PREFIX.length());
            int rightParenIndex = f.indexOf(41);
            if (rightParenIndex == -1) {
                return;
            }
            f = f.substring(0, rightParenIndex);
            try {
                this.rsId = Long.parseLong(f);
            }
            catch (NumberFormatException e) {
                Activator.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.remoteservice", "Exception parsing remote service filter=" + this.filter, (Throwable)e));
            }
        }
    }

    public long getRsId() {
        return this.rsId;
    }

    public RemoteFilterImpl(BundleContext context, String createFilter) throws InvalidSyntaxException {
        if (createFilter == null) {
            throw new InvalidSyntaxException("Filter cannot be null", createFilter);
        }
        this.parseForRsId(createFilter);
        this.filter = context.createFilter(createFilter);
    }

    public RemoteFilterImpl(Filter filter) {
        this.filter = filter;
    }

    public static String getObjectClassFilterString(String objectClass) {
        if (objectClass == null) {
            return null;
        }
        return "(ecf.robjectClass=" + objectClass + ")";
    }

    @Override
    public boolean match(IRemoteServiceReference reference) {
        if (reference == null) {
            return false;
        }
        String[] propertyKeys = reference.getPropertyKeys();
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        int i = 0;
        while (i < propertyKeys.length) {
            props.put(propertyKeys[i], reference.getProperty(propertyKeys[i]));
            ++i;
        }
        return this.match(props);
    }

    public boolean match(Dictionary dictionary) {
        return this.filter.match(dictionary);
    }

    public boolean matchCase(Dictionary dictionary) {
        return this.filter.matchCase(dictionary);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RemoteFilterImpl)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.filter.toString();
    }

    public boolean match(ServiceReference reference) {
        return this.filter.match(reference);
    }

    public boolean matches(Map map) {
        Hashtable dict = new Hashtable(map.size());
        for (Map.Entry entry : map.entrySet()) {
            ((Dictionary)dict).put(entry.getKey(), entry.getValue());
        }
        return this.filter.matchCase(dict);
    }
}

