/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.e4.demo.parts;

import jakarta.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.rap.e4.preferences.EPreference;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class PreferenceSamplePart {
    private Label colorLabel;
    private Color currentColor;
    @Optional
    @Inject
    @Preference
    EPreference prefs;

    @Inject
    public PreferenceSamplePart(Composite parent) {
        parent.setLayout((Layout)new GridLayout(2, false));
        Label l1 = new Label(parent, 0);
        l1.setText("Current Value:");
        this.colorLabel = new Label(parent, 0);
        this.colorLabel.setText("-");
        Label l2 = new Label(parent, 0);
        l2.setText("Color:");
        final Text t = new Text(parent, 2048);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                PreferenceSamplePart.this.prefs.setString("colorPref", t.getText());
            }
        };
        t.addListener(14, listener);
        t.addListener(16, listener);
        t.setLayoutData((Object)new GridData(768));
    }

    @Inject
    public void updatePreference(@Optional @Preference(value="colorPref") String v) {
        if (v == null) {
            return;
        }
        this.colorLabel.setText(v);
        RGB rgb = PreferenceSamplePart.toRGB(v);
        Color c = rgb != null ? new Color((Device)this.colorLabel.getDisplay(), rgb) : null;
        this.colorLabel.setBackground(c);
        if (this.currentColor != null) {
            this.currentColor.dispose();
        }
        this.currentColor = c;
        this.colorLabel.getParent().layout(true);
    }

    private static RGB toRGB(String hexcolor) {
        try {
            if (hexcolor.length() == 3) {
                int r = Integer.parseInt(hexcolor.substring(0, 1), 16) * 17;
                int g = Integer.parseInt(hexcolor.substring(1, 2), 16) * 17;
                int b = Integer.parseInt(hexcolor.substring(2, 3), 16) * 17;
                return new RGB(r, g, b);
            }
            if (hexcolor.length() == 6) {
                int r = Integer.parseInt(hexcolor.substring(0, 2), 16);
                int g = Integer.parseInt(hexcolor.substring(2, 4), 16);
                int b = Integer.parseInt(hexcolor.substring(4, 6), 16);
                return new RGB(r, g, b);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return null;
    }
}

