/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.widgets;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.set.basis.Translateable;
import org.eclipse.set.basis.constants.TableType;
import org.eclipse.set.core.services.enumtranslation.EnumTranslationService;
import org.eclipse.set.utils.Fonts;
import org.eclipse.set.utils.SelectableAction;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class Banderole {
    private static final int OUTDATED_COLOR = 3;
    private static final String OUTDATED_SEPARATOR = " ";
    private static final String TABLE_TYPE_SEPARATOR = " - ";
    private final Composite actionPanel;
    private final StackLayout actionPanelLayout;
    private final EnumTranslationService enumTranslationService;
    private SelectableAction exportAction;
    private final Composite exportButtonComposite;
    private String heading;
    private final Composite headingComposite;
    private final Label label;
    private final LocalResourceManager localResourceManager;
    private final Color originalColor;
    private boolean outdated;
    private SelectableAction outdatedAction;
    private final Composite outdatedButtonComposite;
    private final Composite outdatedEmpty;
    private final String outdatedText;
    private TableType tableType;
    final Button exportButton;
    final Button outdatedButton;

    public Banderole(Composite parent, String outdatedText, EnumTranslationService enumTranslationService) {
        this.enumTranslationService = enumTranslationService;
        this.headingComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.headingComposite);
        this.label = new Label(this.headingComposite, 16384);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.label);
        this.localResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        Font font = (Font)this.localResourceManager.create((DeviceResourceDescriptor)Fonts.TABLE_HEADING);
        this.label.setFont(font);
        this.originalColor = this.label.getBackground();
        this.actionPanel = new Composite(this.headingComposite, 0);
        this.actionPanelLayout = new StackLayout();
        this.actionPanel.setLayout((Layout)this.actionPanelLayout);
        this.outdatedEmpty = new Composite(this.actionPanel, 0);
        GridLayoutFactory.fillDefaults().applyTo(this.outdatedEmpty);
        this.outdatedButtonComposite = new Composite(this.actionPanel, 0);
        GridLayoutFactory.fillDefaults().applyTo(this.outdatedButtonComposite);
        this.outdatedButtonComposite.setBackground(Display.getCurrent().getSystemColor(3));
        this.outdatedButton = new Button(this.outdatedButtonComposite, 0);
        this.exportButtonComposite = new Composite(this.actionPanel, 0);
        GridLayoutFactory.fillDefaults().applyTo(this.exportButtonComposite);
        this.exportButton = new Button(this.exportButtonComposite, 0);
        GridDataFactory.swtDefaults().align(0x1000008, 4).grab(true, false).applyTo((Control)this.exportButton);
        this.actionPanelLayout.topControl = this.outdatedEmpty;
        this.outdatedText = outdatedText;
    }

    public Control getControl() {
        return this.headingComposite;
    }

    public boolean isOutdated() {
        return this.outdated;
    }

    public void setEnableExport(boolean enabled) {
        this.exportButton.setEnabled(enabled);
    }

    public void setExportAction(final SelectableAction exportAction) {
        if (this.exportAction != null) {
            throw new IllegalStateException("export action already set");
        }
        if (exportAction == null) {
            return;
        }
        this.exportAction = exportAction;
        this.exportButton.setText(exportAction.getText());
        final SelectionListener listener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                exportAction.selected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                exportAction.selected(e);
            }
        };
        this.exportButton.addSelectionListener(listener);
        this.exportButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Banderole.this.exportButton.removeSelectionListener(listener);
            }
        });
        this.setTopControl((Control)this.exportButtonComposite);
    }

    public void setHeading(String heading) {
        this.heading = heading;
        this.updateLabel();
    }

    public void setOutdated(boolean outdated) {
        this.outdated = outdated;
        this.updateLabel();
    }

    public void setOutdatedAction(final SelectableAction outdatedAction) {
        if (this.outdatedAction != null) {
            throw new IllegalStateException("outdated action already set");
        }
        if (outdatedAction == null) {
            return;
        }
        this.outdatedAction = outdatedAction;
        this.outdatedButton.setText(outdatedAction.getText());
        final SelectionListener listener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                outdatedAction.selected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                outdatedAction.selected(e);
            }
        };
        this.outdatedButton.addSelectionListener(listener);
        this.outdatedButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Banderole.this.outdatedButton.removeSelectionListener(listener);
            }
        });
    }

    public void setTableType(TableType tableType) {
        this.tableType = tableType;
        this.updateLabel();
    }

    private String getTableTypeString() {
        return this.enumTranslationService.translate((Translateable)this.tableType).getPresentation();
    }

    private void setTopControl(Control control) {
        this.actionPanelLayout.topControl = control;
        this.headingComposite.layout(true, true);
    }

    private void updateLabel() {
        if (this.label.isDisposed()) {
            return;
        }
        StringBuilder text = new StringBuilder();
        text.append(this.heading);
        if (this.tableType != null) {
            text.append(TABLE_TYPE_SEPARATOR);
            text.append(this.getTableTypeString());
        }
        if (this.outdated) {
            this.label.setBackground(Display.getCurrent().getSystemColor(3));
            text.append(OUTDATED_SEPARATOR);
            text.append(this.outdatedText);
            if (this.outdatedAction != null) {
                this.setTopControl((Control)this.outdatedButtonComposite);
            }
        } else {
            this.label.setBackground(this.originalColor);
            if (this.exportAction != null) {
                this.setTopControl((Control)this.exportButtonComposite);
            } else {
                this.setTopControl((Control)this.outdatedEmpty);
            }
        }
        this.label.setText(text.toString());
    }
}

