/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.enumtransformation.impl;

import com.google.common.collect.Maps;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellType;
import org.eclipse.set.core.services.enumtranslation.EnumTranslation;
import org.eclipse.set.feature.enumtransformation.impl.EnumTransformationException;
import org.eclipse.set.feature.enumtransformation.impl.EnumTranslationImpl;
import org.eclipse.set.feature.enumtransformation.impl.TranslationCode;
import org.eclipse.set.utils.enums.EnumTranslationUtils;

public class EnumTransformation {
    private static final int COLUMN_ALTERNATIVE_VALUE = 5;
    private static final int COLUMN_ENUM_TYPE = 1;
    private static final int COLUMN_ENUM_VALUE = 2;
    private static final int COLUMN_PRESENTATION_VALUE = 3;
    private static final int COLUMN_SORTING_VALUE = 4;
    private static final String EMPTY = "<leer>";
    private static final String ENUMS = "ENUMs";
    private static final String XS_PREFIX = "xs:";

    public static TranslationCode transform(Map<String, EnumTranslation> translations) {
        TranslationCode translationCode = new TranslationCode();
        translations.keySet().stream().sorted((a, b) -> a.compareToIgnoreCase((String)b)).forEach(key -> translationCode.add((EnumTranslation)translations.get(key)));
        return translationCode;
    }

    /*
     * Loose catch block
     */
    public static Map<String, EnumTranslation> transform(Path path) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            Map<String, EnumTranslation> map;
            HSSFWorkbook document;
            FileInputStream input;
            block16: {
                block15: {
                    input = new FileInputStream(path.toFile());
                    document = new HSSFWorkbook((InputStream)input);
                    map = EnumTransformation.transform(document);
                    if (document == null) break block15;
                    document.close();
                }
                if (input == null) break block16;
                input.close();
            }
            return map;
            {
                catch (Throwable throwable2) {
                    try {
                        if (document != null) {
                            document.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (input != null) {
                            input.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private static String transform(double value) {
        return EnumTransformation.transformToValue(Long.toString(Math.round(value)));
    }

    private static String transform(HSSFCell cell) {
        if (cell == null) {
            return null;
        }
        CellType cellType = cell.getCellType();
        switch (cellType) {
            case BLANK: {
                return null;
            }
            case STRING: {
                return EnumTransformation.transformToValue(cell.getStringCellValue());
            }
            case NUMERIC: {
                return EnumTransformation.transform(cell.getNumericCellValue());
            }
        }
        throw new IllegalArgumentException(cellType.toString());
    }

    private static EnumTranslation transform(HSSFRow row) {
        return new EnumTranslationImpl(EnumTransformation.transformToKeyBasis(row), EnumTransformation.transformToPresentation(row), EnumTransformation.transformToAlternative(row), EnumTransformation.transformToSorting(row));
    }

    private static Map<String, EnumTranslation> transform(HSSFWorkbook document) {
        HashMap result = Maps.newHashMap();
        HSSFSheet sheet = document.getSheet(ENUMS);
        int rowIndex = sheet.getFirstRowNum() + 1;
        while (rowIndex <= sheet.getLastRowNum()) {
            HSSFRow row = sheet.getRow(rowIndex);
            try {
                EnumTranslation translation = EnumTransformation.transform(row);
                result.put(translation.getKeyBasis(), translation);
            }
            catch (Exception e) {
                throw new EnumTransformationException(e, row);
            }
            ++rowIndex;
        }
        return result;
    }

    private static String transformToValue(String value) {
        return value.replaceAll("<leer>|xs:", "");
    }

    static String transformToAlternative(HSSFRow row) {
        String alternative = EnumTransformation.transform(row.getCell(5));
        if (alternative != null) {
            return alternative;
        }
        return EnumTransformation.transformToPresentation(row);
    }

    static String transformToKeyBasis(HSSFRow row) {
        String enumType = EnumTransformation.transform(row.getCell(1));
        String enumValue = EnumTransformation.transform(row.getCell(2));
        return EnumTranslationUtils.getKeyBasis((String)enumType, (String)enumValue);
    }

    static String transformToPresentation(HSSFRow row) {
        return EnumTransformation.transform(row.getCell(3));
    }

    static String transformToSorting(HSSFRow row) {
        return EnumTransformation.transform(row.getCell(4));
    }
}

