/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.validation.service;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.set.core.services.validation.CustomValidator;
import org.eclipse.set.feature.validation.service.ValidationServiceImpl;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={IContextFunction.class}, property={"service.context.key:String=org.eclipse.set.core.services.validation.ValidationService"})
public class ValidationServiceContextFunction
extends ContextFunction {
    private final Set<CustomValidator> customValidators = new HashSet<CustomValidator>();
    private IEclipseContext eclipseContext;
    private ValidationServiceImpl validationService;

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addCustomValidator(CustomValidator validator) {
        this.customValidators.add(validator);
        if (this.validationService != null) {
            validator.setMessagesProvider(ContextInjectionFactory.make((Class)validator.getMessageProviderClass(), (IEclipseContext)this.eclipseContext));
            this.validationService.addCustomValidator(validator);
        }
    }

    public Object compute(IEclipseContext context, String contextKey) {
        this.eclipseContext = context;
        this.validationService = (ValidationServiceImpl)ContextInjectionFactory.make(ValidationServiceImpl.class, (IEclipseContext)context);
        this.customValidators.forEach(validator -> {
            validator.setMessagesProvider(ContextInjectionFactory.make((Class)validator.getMessageProviderClass(), (IEclipseContext)context));
            this.validationService.addCustomValidator((CustomValidator)validator);
        });
        return this.validationService;
    }

    public void removeCustomValidator(CustomValidator validator) {
        this.customValidators.remove(validator);
        this.validationService.removeCustomValidator(validator);
    }
}

