/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.validation.table;

import java.util.List;
import java.util.Set;
import org.eclipse.set.feature.validation.table.ValidationTableColumns;
import org.eclipse.set.model.tablemodel.ColumnDescriptor;
import org.eclipse.set.model.tablemodel.TableRow;
import org.eclipse.set.model.tablemodel.extensions.TableRowExtensions;
import org.eclipse.set.model.validationreport.ObjectScope;
import org.eclipse.set.model.validationreport.ObjectState;
import org.eclipse.set.model.validationreport.ValidationProblem;
import org.eclipse.set.model.validationreport.ValidationReport;
import org.eclipse.set.utils.table.TMFactory;
import org.eclipse.set.utils.table.tree.AbstractValidationProblemTransformator;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class ValidationReportTableTransformator
extends AbstractValidationProblemTransformator<ValidationReport> {
    private ValidationTableColumns columns;
    protected final List<ColumnDescriptor> excludeColumns;
    private static final String SPECIFIC_VALUE_REGEX = "'[^']+'";

    public ValidationReportTableTransformator(ValidationTableColumns columns) {
        this.columns = columns;
        this.excludeColumns = CollectionLiterals.newArrayList((Object[])new ColumnDescriptor[]{columns.RowIndex, columns.Message, columns.LineNumber});
    }

    public List<ValidationProblem> getProblems(ValidationReport report) {
        return report.getProblems();
    }

    public void fillProblem(TableRow instance, ValidationProblem problem) {
        boolean _notEquals;
        Functions.Function1 _function = it -> Integer.valueOf(problem.getId()).toString();
        this.fill(instance, this.columns.RowIndex, problem, _function);
        Functions.Function1 _function_1 = it -> it.getSeverityText();
        this.fill(instance, this.columns.Severity, problem, _function_1);
        Functions.Function1 _function_2 = it -> it.getType();
        this.fill(instance, this.columns.ProblemType, problem, _function_2);
        int _lineNumber = problem.getLineNumber();
        boolean bl = _notEquals = _lineNumber != 0;
        if (_notEquals) {
            Functions.Function1 _function_3 = it -> it.getLineNumber();
            this.fillNumeric(instance, this.columns.LineNumber, problem, _function_3);
        }
        Functions.Function1 _function_4 = it -> it.getObjectArt();
        this.fill(instance, this.columns.ObjectType, problem, _function_4);
        Functions.Function1 _function_5 = it -> it.getAttributeName();
        this.fill(instance, this.columns.AttributeGroup, problem, _function_5);
        Functions.Function1 _function_6 = it -> {
            ObjectScope _objectScope = it.getObjectScope();
            String _string = null;
            if (_objectScope != null) {
                _string = _objectScope.toString();
            }
            return _string;
        };
        this.fill(instance, this.columns.ObjectScope, problem, _function_6);
        Functions.Function1 _function_7 = it -> {
            ObjectState _objectState = it.getObjectState();
            String _literal = null;
            if (_objectState != null) {
                _literal = _objectState.getLiteral();
            }
            return _literal;
        };
        this.fill(instance, this.columns.ObjectState, problem, _function_7);
        Functions.Function1 _function_8 = it -> it.getMessage();
        this.fill(instance, this.columns.Message, problem, _function_8);
    }

    public TableRow createGroupAbstractRow(TMFactory factory, List<TableRow> groupRows) {
        boolean _tripleEquals;
        TableRow rootRow = super.createGroupAbstractRow(factory, groupRows);
        Functions.Function1 _function = it -> {
            String _plainStringValue = TableRowExtensions.getPlainStringValue((TableRow)it, (ColumnDescriptor)this.getMessagesColumn());
            String _replaceAll = null;
            if (_plainStringValue != null) {
                _replaceAll = _plainStringValue.replaceAll(SPECIFIC_VALUE_REGEX, "...");
            }
            return _replaceAll;
        };
        Set allMsg = IterableExtensions.toSet((Iterable)IterableExtensions.filterNull((Iterable)ListExtensions.map(groupRows, (Functions.Function1)_function)));
        int _length = ((Object[])Conversions.unwrapArray((Object)allMsg, Object.class)).length;
        boolean bl = _tripleEquals = _length == 1;
        if (_tripleEquals) {
            TableRowExtensions.set((TableRow)rootRow, (ColumnDescriptor)this.getMessagesColumn(), (String)((String[])Conversions.unwrapArray((Object)allMsg, String.class))[0]);
        } else {
            TableRowExtensions.set((TableRow)rootRow, (ColumnDescriptor)this.getMessagesColumn(), (String)"");
        }
        return rootRow;
    }

    public List<ColumnDescriptor> getExcludeColumns() {
        return this.excludeColumns;
    }

    public ColumnDescriptor getIndexColumn() {
        return this.columns.RowIndex;
    }

    public ColumnDescriptor getMessagesColumn() {
        return this.columns.Message;
    }
}

